# -*- coding: UTF-8 -*-
from frame.cli import cliUtil
from frame.common import common
from frame.common.config import RISK_VERSION_PATH
from frame.context import contextUtil

def execute(context):
    '''
            风险路径检查: 
                    如果在风险路径中，检查不通过，否则检查通过。
    '''
    lang = contextUtil.getLang(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    cli = contextUtil.getSSH(context)
    flag = True
    cliRet = ""
    errMsg = ""
    
    try:
        versionFlag, devVersion, cliRet = common.getDevVersion(cli, lang, logger)
        pkgVersion = contextUtil.getTargetVersion(context)
        logger.logInfo("devVersion is [%s],pkgVersion is [%s]." % (devVersion, pkgVersion))
        for checkSysVersionPath in RISK_VERSION_PATH:
            if devVersion == checkSysVersionPath.get('curVersion') and pkgVersion == checkSysVersionPath.get('upgradePkgVersion'):
                flag = False
                errMsg = common.getMsg(lang, "exist.risk.versionPath")
                break
        return common.getUpgEvaluationRs(flag, cliRet, errMsg)
        
    except Exception, exception:
        logger.logException(exception)
        return common.getUpgEvaluationRs(False, cliRet, common.getMsg(lang, "query.result.abnormal"))
