# -*- coding: UTF-8 -*-
from frame.common import common
from frame.cli import cliUtil
from frame.context import contextUtil
from frame.tlv import tlvUtil
from frame.tlv import tlvData

def execute(context):
    '''
    @summary: PCIe链路检查
    '''
    
    lang = contextUtil.getLang(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    cliRet = ""
    try:
        
        tlv = contextUtil.getTlvObj(context)
        flag = True
        errMsg = ""
        checkItem = "CHECK_HARDWARE_PCIE_LINKSTATUS"
        logger.logExecCmd(checkItem)
        itemDict = tlvData.UPD_CHECK_RESULT[checkItem]#根据检查项获取配置字典值
        recs = tlvUtil.getUpgradeRecords(tlv, checkItem)
        logger.logInfo("records=%s" % unicode(recs))
        
        #获取cli回显，保存在cliRetList
        cli = contextUtil.getSSH(context)
        cliRetList = constructCliRet(cli, logger, lang)
        cliRet = "\n".join(cliRetList)
        
        errMsgList = []#保存错误信息的列表
        for record in recs:
            result = tlvUtil.getRecordValue(record, tlvData.CMO_UPD_EXECUTE_DEFINE["RESULT"])
            nodeId = tlvUtil.getRecordValue(record, tlvData.CMO_UPD_EXECUTE_DEFINE["NODE_ID"])
            itemKey = itemDict.get(result, None)
            if itemKey is None:
                errMsgList.append(common.getMsg(lang, "query.result.abnormal"))
                flag = False
                continue
            #只有status为False时才获取错误信息
            status = itemKey["status"]
            if status is True:
                continue
            flag = False
            errMsgList.append(common.getMsg(lang, itemKey["msg"], nodeId))
        errMsg = "".join(errMsgList)
        return common.getUpgEvaluationRs(flag, cliRet, errMsg)
    
    except Exception, exception:
        logger.logException(exception)
        return common.getUpgEvaluationRs(False, cliRet, common.getMsg(lang, "query.result.abnormal"))

def constructCliRet(cli, logger, lang):
    '''
    @summary: 构造CLI回显
    '''
    cliRetList = []
    try:
        cmdList = list()
        cmdList.append("sys showcls")
        cliRetList = cliUtil.GetCliRecsInDebugMode(cli, cmdList, logger, lang)
        
        recsList = cliUtil.getVerticalCliRet(cliRetList[0])
        nodeCfg = recsList[0].get("node cfg")
        localNode = int(recsList[0].get("local node id"))
        if nodeCfg != None and nodeCfg.isdigit() and int(nodeCfg) >= 4:
            cmdList = list()
            for node in range(0,int(nodeCfg)):
                if localNode == node:
                    continue
                cmdList.append("xnet showconn -c %s" % node)
            cliRetList += cliUtil.GetCliRecsInDebugMode(cli, cmdList, logger, lang)
        return cliRetList
    except Exception, exception: 
        logger.logException(exception)
        return cliRetList
    
    
    
    
    
    
    

    