# -*- coding: UTF-8 -*-
from frame.cli import cliUtil
from frame.common import common
from frame.context import contextUtil

def execute(context):
    '''
    BBU寿命检查: 
                剩余时间（Remaining Lifetime）小于90天，即认为快到期，应该尽快更换。未查到时间属于不正常状态。
    '''
    LANG = contextUtil.getLang(context)
    LOGGER = common.getLogger(contextUtil.getLogger(context), __file__)
    cli = contextUtil.getSSH(context)
    flag = True
    cliRet = ""
    cliRetAll = ""
    errMsg = ""

    try:
        cmd = "show bbu life"
        LOGGER.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInDeveloperMode(cli, cmd, True, LANG)
        if checkRet[0] != True:
            LOGGER.logSysAbnormal()
            return common.getUpgEvaluationRs(checkRet[0], checkRet[1], checkRet[2])
        
        cliRet = checkRet[1]
        cliRetAll += cliRet
        cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
        
        if len(cliRetLinesList) == 0:
            errMsg = common.getMsg(LANG, "cannot.get.remaining.lifetime.info")
            LOGGER.logNoPass("Cannot get information about Remaining Lifetime of BBU")
            return common.getUpgEvaluationRs(False, cliRetAll, errMsg)
        
        for line in cliRetLinesList:
            bbuId = line["ID"]
            remainingLifetime = line["Remaining Lifetime(days)"]
            if remainingLifetime.isdigit():
                if int(remainingLifetime) < common.THRESHOLD_BBU_REMAINING_LIFETIME:
                    flag = False
                    errMsg += common.getMsg(LANG, "bbu.remaining.lifetime.abnormal", 
                        (bbuId, common.THRESHOLD_BBU_REMAINING_LIFETIME, remainingLifetime))
                    LOGGER.logNoPass("The Remaining Lifetime of BBU [%s] is less than [%s] days (Remaining Lifetime:%s)" 
                         % (bbuId, common.THRESHOLD_BBU_REMAINING_LIFETIME, remainingLifetime))
            else:
                flag = False
                errMsg += common.getMsg(LANG, "cannot.get.bbu.remaining.lifetime", bbuId)
                LOGGER.logNoPass("Cannot get information about Remaining Lifetime of BBU[%s" % bbuId)
            
        if flag:
            LOGGER.logPass()
            
        return common.getUpgEvaluationRs(flag, cliRetAll, errMsg)
    
    except Exception, exception:
        LOGGER.logException(exception)
        return common.getUpgEvaluationRs(False, cliRet, common.getMsg(LANG, "query.result.abnormal"))
