# -*- coding: UTF-8 -*-
from frame.cli import cliUtil
from frame.common import common
from frame.context import contextUtil

def execute(context):
    '''IPv6锁业务检查：
       1 show logical_port general查看“IPv6 Address”项是否配置有IPv6的Ip地址。
       2 如果没有IPv6配置，则检查通过，否则升级存在风险，具体请参考修复案例手动排查。
    '''
    lang = contextUtil.getLang(context)
    cli = contextUtil.getSSH(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    
    flag = True
    cliRet = ""
    errMsg = ""
    
    #检查当前版本是否涉及当前检查项
    if not common.needCheckItem(contextUtil.getCurVersion(context), __file__):
        logger.logInfo('The current version is not involved the check item')
        return common.getUpgEvaluationRsNoInvolved()
    
    try:
        cmd = "show logical_port general"
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
        cliRet = checkRet[1]
        if checkRet[0] != True:
            logger.logSysAbnormal()
            return common.getUpgEvaluationRs(checkRet[0], checkRet[1], checkRet[2])
        
        cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
        logger.logInfo("cliRet of IPV6serveice%s" % str(cliRetLinesList))
        #如果没有IPv6配置，检查通过，否则不通过。
        for item in cliRetLinesList:
            if item["IPv6 Address"] != "--":
                flag = False
                errMsg = common.getMsg(lang, "IPv6LockService.notpass")
                break
                
        return common.getUpgEvaluationRs(flag, cliRet, errMsg)
    
    except Exception, exception:
        logger.logException(exception)
        return common.getUpgEvaluationRs(False, cliRet, common.getMsg(lang, 'query.result.abnormal'))
    
