# -*- coding: UTF-8 -*-
from frame.cli import cliUtil
from frame.common import common
from frame.context import contextUtil
import time
import os


PASSED = 0
NOTPASSED = 1
ERROR = 2

def execute(context):
    '''
        1 如果所有控制器都没有配置nfs和cifs服务，则检查通过。
        2 每隔2秒钟执行一次，执行10次，如果Request total 不为0，且Request free 为0，并且没有变化，则存在挂IO的风险，检查不通过。
        3 如果登录到其它控制器不成功，则检查结果为未检查。
        4 其他情况检查通过。
    '''
    lang = contextUtil.getLang(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    
    flag = True
    cliRet = ""
    errMsg = ""
    
    #检查当前版本是否涉及当前检查项
    if not common.needCheckItem(contextUtil.getCurVersion(context), __file__):
        logger.logInfo('The current version is not involved the check item')
        return common.getUpgEvaluationRsNoInvolved()
    
    
    #步骤1：获取所有控制器IP和ID
    ctrlIpAndIdTupList = contextUtil.getItem(context, "allCtrlsIp")
    if not ctrlIpAndIdTupList:
        #无法获取控制器ip
        logger.logInfo(common.getMsg(lang, 'cannot.ctrl.id.ip'))
        return common.getUpgEvaluationRs(cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(lang, 'cannot.ctrl.id.ip'))
    
    #将回显和控制器信息拼接起来
    cliRetList = []
    resultList = []
    for contrlInfo in ctrlIpAndIdTupList:
        ctrlId = contrlInfo[0]
        ctrlIpv4 = contrlInfo[1]
        ctrlIpv6 = contrlInfo[2]
        #检查可能结果：通过，不通过，未检查
        checkRet = check(context, (ctrlIpv4,ctrlIpv6), ctrlId)
        
        if checkRet[0] != cliUtil.RESULT_NOCHECK:
            cliRetList.append(common.CONTROLLER_INFO % (ctrlId))
            cliRetList.append(checkRet[1] + "\n")
            
        resultList.append(checkRet[0])
        #中间变量保存显示信息。
        midMsg = checkRet[2]
        if checkRet[0] is True:#通过
            midMsg = common.getMsg(lang, "controller.check.pass")
        errMsg += common.getMsg(lang, 'title.controller', ctrlId) + midMsg + os.linesep
        
    flag = common.getCheckResult(resultList)
    logger.logInfo("resultList flag is:%s" % str(resultList))
    cliRet = '\n'.join(cliRetList)   
    return common.getUpgEvaluationRs(flag, cliRet, errMsg) 
    

def checkNFSBusiness(cli, cmd, lang, logger):
    """
    @summary: 执行一次检查.
    @param cli: cli对象
    @param cmd: 在developer模式下，执行 的命令。
    @param lang: 语言lang
    @return :(flag, cliRet, requestValue)
             flag:
                 True:单次检查成功，
                 False:单次检查失败。
             cliRet:该次检查的回显信息，
             requestValue:保存每次的“Request total”的值.
    """
    
    requestValue = ""
    checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
    cliRet = checkRet[1]
    if checkRet[0] != True:
        return (ERROR, cliRet, requestValue)
    cliRetList = cliUtil.getVerticalCliRet(cliRet)
    for item in cliRetList:
        logger.logInfo("Current Request Total is [%s]" % item["Request Total"])
        logger.logInfo("Current Request Free is [%s]" % item["Request Free"])
        if item["Request Total"] != "0" and item["Request Free"] == "0":
            requestValue = item["Request Total"]
            return (NOTPASSED, cliRet, requestValue)
         
    return (PASSED, cliRet, requestValue)

def check(context, ctrlIps, ctrlId):
    """
    @summary: 在一个控制器上执行检查。
    @param cli: cli对象
    @param lang: 语言lang
    @return :(flag, cliRet)
             flag:
                 True:相等，
                 False:不相等。
             cliRet:回显信息。
    """
    lang = contextUtil.getLang(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    
    flag = True
    cliRet = ""
    errMsg = ""
    logger.logInfo("start checking controller[%s]" %ctrlId)
    
    try:
        curCtrlIp = contextUtil.getCurCtrlIp(context)
        if curCtrlIp == ctrlIps[0] or curCtrlIp == ctrlIps[1]:#当前控制器直接获取
            cli = contextUtil.getSSH(context)
        else:#创建cli连接，先使用ipv4创建，如果失败再用ipv6创建
            cli = contextUtil.createCliConnection(context, ctrlIps[0])
            if cli is None:
                cli = contextUtil.createCliConnection(context, ctrlIps[1])
        
        if cli is None:
            logger.logInfo("create controller [%s] cli connection failed"%ctrlId)
            errMsg = common.getMsg(lang, "cannot.create.controller.cli")
            return (cliUtil.RESULT_NOCHECK, "", errMsg)
    
        #进入developer模式下。
        enterDeveloperCheckRet = cliUtil.enterDeveloperMode(cli, lang)
        if enterDeveloperCheckRet[0] != True:
            logger.logInfo("controller [%s] enter developer mode failed"%ctrlId)
            errMsg = common.getMsg(lang, "enterDeveloperMode.failure")
            return (False, cliRet, errMsg)
        
        nfs_cmd = "show nfs server_info"
        cifs_cmd = "show cifs server_info"
        
        checkResult = []
        for i in range(10):
            nfs_cliRet = checkNFSBusiness(cli, nfs_cmd, lang, logger)
            cifs_cliRet = checkNFSBusiness(cli, cifs_cmd, lang, logger)
            
            #执行检查时出错直接退出循环
            logger.logInfo("nfs_cliRet is:[%s]" % str(nfs_cliRet))
            logger.logInfo("cifs_cliRet is:[%s]" % str(cifs_cliRet))
            if nfs_cliRet[0] == ERROR or cifs_cliRet[0] == ERROR:
                flag = False
                break
            
            #判断回显是否为"Command executed successfully"，如果两个的都返回True跳出
            if cliUtil.queryResultWithNoRecord(nfs_cliRet[1]) and cliUtil.queryResultWithNoRecord(cifs_cliRet[1]):
                break
            
            logger.logInfo("checkResult[0]:%s" % str((nfs_cliRet[2],cifs_cliRet[2])))
            checkResult.append((nfs_cliRet[2],cifs_cliRet[2]))
            if nfs_cliRet[0] != PASSED or cifs_cliRet[0] != PASSED:
                fsInfo = checkResult[0]
                if fsInfo != (nfs_cliRet[2], cifs_cliRet[2]):
                    break
                #10次都没有变化，检查不通过
                if len(checkResult) == 10:
                    flag = False
            time.sleep(2)
            
        if flag is not True:
            errMsg = common.getMsg(lang, "Nfsshared.check.notpass")
        
        #退出developer模式
        cliUtil.developerMode2CliMode(cli)
        
        #处理回显，cliRetList中间变量
        cliRet = "\n".join([nfs_cliRet[1],cifs_cliRet[1]])
        return (flag, cliRet, errMsg)
            
    except Exception, exception:
        logger.logException(exception)
        return (False, cliRet, common.getMsg(lang, "query.controller.result.abnormal"))
        
    finally:
        #关闭连接cli
        if curCtrlIp != ctrlIps[0] and curCtrlIp != ctrlIps[1]:
            cliUtil.closeCliConnection(cli)
