# -*- coding: UTF-8 -*-
import traceback
import os
import re

from frame.common import common
from frame.common.regex import RegPattern
from frame.cli import cliUtil
from frame.context import contextUtil


def execute(context):
    '''
    @summary: the entrance of main method, this check item is used to check IO status
    @param context: the dictionary of data which provided by tool framework
    @return: (pass status, CLI information, error message) as (integer, string, string)
    '''
    flag = True
    cliRet = ''
    errMsg = ''
    lang = contextUtil.getLang(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    
    #检查当前版本是否涉及当前检查项
    if not common.needCheckItem(contextUtil.getCurVersion(context), __file__):
        logger.logInfo('The current version is not involved the check item')
        return common.getUpgEvaluationRsNoInvolved()
    try:
        #步骤1：获取所有控制器IP和ID
        ctrlIpAndIdTupList = contextUtil.getItem(context, "allCtrlsIp")
        if not ctrlIpAndIdTupList:
            #无法获取控制器ip
            logger.logInfo(common.getMsg(lang, 'cannot.ctrl.id.ip'))
            return common.getUpgEvaluationRs(cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(lang, 'cannot.ctrl.id.ip'))
        
        #将回显和控制器信息拼接起来
        cliRetList = []
        resultList = []
        #步骤2：对每个控制器都执行检查
        for contrlInfo in ctrlIpAndIdTupList:
            ctrlId = contrlInfo[0]
            ctrlIpv4 = contrlInfo[1]
            ctrlIpv6 = contrlInfo[2]
            checkRet = checkEachCtrlIoStatus(context, (ctrlIpv4,ctrlIpv6), ctrlId)
            
            if checkRet[0] != cliUtil.RESULT_NOCHECK:
                cliRetList.append(common.CONTROLLER_INFO % (ctrlId))
                cliRetList.append(checkRet[1] + "\n")
                
            resultList.append(checkRet[0])
            #中间变量保存显示信息。
            midMsg = checkRet[2]
            if checkRet[0] is True:#通过
                midMsg = common.getMsg(lang, "controller.check.pass")
            errMsg += common.getMsg(lang, 'title.controller', ctrlId) + midMsg + os.linesep
            
        flag = common.getCheckResult(resultList)
        logger.logInfo("resultList flag is:%s" % str(resultList))
        cliRet = '\n'.join(cliRetList)
        return common.getUpgEvaluationRs(flag, cliRet.strip(), errMsg)
    except Exception, exception: 
        logger.logException(exception)
        return common.getUpgEvaluationRs(False, cliRet.strip(), common.getMsg(lang, 'query.result.abnormal'))


def checkEachCtrlIoStatus(context, ctrlIps, ctrlId):
    lang = contextUtil.getLang(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    
    flag = True
    cliRet = ''
    errMsg = ''
    logger.logInfo('start checking controller[%s]' % ctrlId)
    
    curCtrlIp = contextUtil.getCurCtrlIp(context)
    ctrlIp = ''
    if re.match(RegPattern.IPV4, curCtrlIp):#IPV4
        ctrlIp = ctrlIps[0]
    else:#IPV6
        ctrlIp = ctrlIps[1]
    
    if curCtrlIp == ctrlIp:#当前控制器直接获取
        cli = contextUtil.getSSH(context)
    else:#新建cli连接
        #先使用ipv4创建，如果失败再用ipv6创建
        cli = contextUtil.createCliConnection(context, ctrlIps[0])
        if cli is None:
            cli = contextUtil.createCliConnection(context, ctrlIps[1])
    
    if cli == None:
        logger.logInfo('create controller [%s] cli connection failed' % ctrlId)
        errMsg = common.getMsg(lang, 'cannot.create.controller.cli')
        return (cliUtil.RESULT_NOCHECK, '', errMsg)
    
    try:
        #查询透写等待IO数目：为0个或没有表示检查通过
        cmd = 'writehole showlist'
        flag, cliRet, errMsg = cliUtil.executeCmdInDebugMode(cli, cmd, True, lang, contextUtil.getDeveloperPwd(context))
        if flag != True:
            logger.logSysAbnormal()
            return (flag, cliRet, errMsg)
        keyword = 'writehole wait io num'
        if re.search(keyword, cliRet, re.IGNORECASE):
            writeholeWaitIoNum = getWriteholeWaitIoNum(cliRet, keyword)
            if '0' != writeholeWaitIoNum:
                errMsg = common.getMsg(lang, 'check.io.status.notpass')
                return (False, cliRet, errMsg)
        return (True, cliRet, errMsg)
    except Exception, exception:
        logger.logException(exception)
        return (False, cliRet, common.getMsg(lang, "query.result.abnormal"))
    finally:
        if curCtrlIp != ctrlIp:
            cliUtil.closeCliConnection(cli)


def getWriteholeWaitIoNum(cliRet, keyword):
    '''
    @summary: get the number of writehole wait IO
    @param cliRet: the CLI information of command 'writehole showlist'
    @param keyword: the keyword which need to look for
    @return: the number of writehole wait IO as string
    '''
    tmpNum = ''
    lineList = cliRet.splitlines()
    for line in lineList:
        if keyword in line:
            tmpNum = line.split(':')[-1]
            break
    return tmpNum.strip()

