# -*- coding: UTF-8 -*-
from frame.cli import cliUtil
from frame.common import common
from frame.context import contextUtil

def execute(context):
    '''
                      远端LUN路径状态检查： 
        Status为Running，并且Path Priority取值非Unavailable时表示正常，其它情况均属于不正常状态。
    '''
    lang = contextUtil.getLang(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    cli = contextUtil.getSSH(context)
    flag = True
    cliRet = ""
    errMsg = ""
    
    try:
        cmd = "show remote_lun path_status|filterRow column=Status predict=not predict2=equal_to value=Running logicOp=or column=Path\sPriority predict=equal_to value=Unavailable"
        logger.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInDeveloperMode(cli, cmd, True, lang)
        if checkRet[0] != True:
            logger.logSysAbnormal()
            return common.getUpgEvaluationRs(checkRet[0], checkRet[1], checkRet[2])
        
        cliRet = checkRet[1]
        if cliUtil.queryResultWithNoRecord(cliRet):
            return common.getUpgEvaluationRs(True, cliRet, checkRet[2])
        
        cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
        if len(cliRetLinesList) == 0:
            flag = False
            errMsg = common.getMsg(lang, "cannot.get.remote.lun.info")
            logger.logNoPass("Cannot get information about remote LUN")
        
        elif len(cliRetLinesList) > 0:
            flag = False
            errMsg = common.getMsg(lang, "remote.lun.path.status.abnormal")
            logger.logNoPass("The path status of remote LUN is abnormal")
            
        if flag:
            logger.logPass()
              
        return common.getUpgEvaluationRs(flag, cliRet, errMsg)
        
    except Exception, exception:
        logger.logException(exception)
        return common.getUpgEvaluationRs(False, cliRet, common.getMsg(lang, "query.result.abnormal"))
