# -*- coding: UTF-8 -*-
from frame.cli import cliUtil
from frame.common import common
from frame.context import contextUtil

def execute(context):
    '''
        LUN状态检查: 
                      如果不存在相应的记录表示正常，否则属于不正常状态。
    '''
    lang = contextUtil.getLang(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    cli = contextUtil.getSSH(context)
    flag = True
    cliRet = ""
    errMsg = ""
    
    try:
        cmd = "show lun general|filterRow column=Health\sStatus predict=not predict2=equal_to value=Normal logicOp=or column=Running\sStatus predict=not predict2=equal_to value=Online |filterColumn include columnList=ID,Running\sStatus,Health\sStatus"
        logger.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
        if checkRet[0] != True: 
            logger.logSysAbnormal()
            return common.getUpgEvaluationRs(checkRet[0], checkRet[1], checkRet[2])
        
        cliRet = checkRet[1]
        if cliUtil.queryResultWithNoRecord(cliRet):
            return common.getUpgEvaluationRs(True, cliRet, checkRet[2])
        
        cliRetLinesList = cliUtil.getHorizontalNostandardCliRet(cliRet)
        if len(cliRetLinesList) == 0:
            errMsg = common.getMsg(lang, "cannot.get.lun.info")
            logger.logNoPass("Cannot get information about LUN")
            return common.getUpgEvaluationRs(False, cliRet, checkRet[2])

        for line in cliRetLinesList:
            lunId = line["ID"]
            runningStatus = line.get("Running Status", "")
            healthStatus = line.get("Health Status", "")
            if healthStatus.lower() == "normal" \
                    and (runningStatus.lower() == "running normal" or runningStatus.lower() == "running success"):
                continue
            flag = False
            errMsg += common.getMsg(lang, "lun.status.abnormal", lunId)
            logger.logNoPass("The status of LUN [%s] is abnormal" % lunId)
            
        if flag:
            logger.logPass()
            
        return common.getUpgEvaluationRs(flag, cliRet, errMsg)
        
    except Exception, exception:
        logger.logException(exception)
        return common.getUpgEvaluationRs(False, cliRet, common.getMsg(lang, "query.result.abnormal"))
