# -*- coding: UTF-8 -*-
from frame.common import common
from frame.context import contextUtil
from cbb.frame.base.config import HOT_PATCH_VERSION_DICT, \
    SPECIAL_HOT_PATCH_DOWNLOAD_PATH, HOT_PATCH_DEVTYPE_WHITE_DICT
from frame.common.regex import Regex

def execute(context):
    '''
    @summary: 特殊路径下是否安装热补丁
    '''
    lang = contextUtil.getLang(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    cli = contextUtil.getSSH(context)
    
    cliRet = ""
    errMsg = ""
    try:
        # 获取当前版本号
        getDevVersionRet = common.getDevVersion(cli, lang, logger)
        if not getDevVersionRet[0]:
            errMsg = common.getMsg(lang, "cannot.get.version")
            return common.getUpgEvaluationRs(getDevVersionRet[0], getDevVersionRet[2], errMsg)
        curVersion = getDevVersionRet[1]
        logger.logInfo('curVersion:%s'%curVersion)
        cliRet = getDevVersionRet[2]

        # 某些版本的某些设备类型不需要检查补丁
        devType = contextUtil.getDevType(context)
        for key in HOT_PATCH_DEVTYPE_WHITE_DICT.keys():
            if key == curVersion and devType in HOT_PATCH_DEVTYPE_WHITE_DICT.get(key):
                logger.logInfo("the version %s no need check patch." % key)
                return common.getUpgEvaluationRs(True, cliRet, errMsg)

        # 检查是否检查安装了特定版本的补丁
        if curVersion not in HOT_PATCH_VERSION_DICT.keys():
            return common.getUpgEvaluationRs(True, cliRet, errMsg)
        expectedPatchVersions = HOT_PATCH_VERSION_DICT.get(curVersion)
        logger.logInfo('expectedPatchVersions:%s' % expectedPatchVersions)

        # 获取补丁版本号
        getHotPatchVersionRet = common.getHotPatchVersion(cli, lang)
        if not getHotPatchVersionRet[0]:
            return common.getUpgEvaluationRs(getHotPatchVersionRet[0], getHotPatchVersionRet[2], getHotPatchVersionRet[3])
        currentPatchVersion = getHotPatchVersionRet[1]
        logger.logInfo('currentPatchVersion:%s' % currentPatchVersion)

        # 判断标准以最后安装补丁为准
        lastExptectedPatchVersion = expectedPatchVersions[-1]
        if lastExptectedPatchVersion.endswith('+'):
            if currentPatchVersion < lastExptectedPatchVersion[:-1]:
                errMsg = getErrMsg(curVersion, expectedPatchVersions, lang)
                return common.getUpgEvaluationRs(False, cliRet, errMsg)
        elif lastExptectedPatchVersion.endswith('*'):
            if Regex.find("SPH.99$", currentPatchVersion, Regex.IGNORECASE):
                errMsg = getErrMsg(curVersion, expectedPatchVersions, lang, True)
                return common.getUpgEvaluationRs(False, cliRet, errMsg)
            if currentPatchVersion < lastExptectedPatchVersion[:-1]:
                errMsg = getErrMsg(curVersion, expectedPatchVersions, lang)
                return common.getUpgEvaluationRs(False, cliRet, errMsg)
        else:
            if currentPatchVersion != lastExptectedPatchVersion :
                errMsg = getErrMsg(curVersion, expectedPatchVersions, lang)
                return common.getUpgEvaluationRs(False, cliRet, errMsg)
        return common.getUpgEvaluationRs(True, cliRet, "")

    except Exception, exception:
        logger.logException(exception)
        return common.getUpgEvaluationRs(False, cliRet, common.getMsg(lang, "query.result.abnormal"))

def getErrMsg(curVersion, expectedPatchVersions, lang, isX99=False):
    # 生成期望的补丁版本
    expectedVersionStr = common.getMsg(lang, 'comma.res').join(expectedPatchVersions)
    expectedVersionStr = expectedVersionStr.replace('*', common.getMsg(lang, 'hotpatch.version.later'))
    expectedVersionStr = expectedVersionStr.replace('+', common.getMsg(lang, 'hotpatch.version.later'))
    expectedVersionStr = Regex.replaceAll("B01[2,3]", expectedVersionStr, '')

    # 从配置中获取补丁集有特有的下载地址
    downPathDict = SPECIAL_HOT_PATCH_DOWNLOAD_PATH.get(lang)
    if curVersion in downPathDict.keys():
        isPatchSet = True
        patchDownPath = downPathDict.get(curVersion)
    else:
        isPatchSet = False
        patchDownPath = downPathDict.get("Default")

    if len(expectedPatchVersions) == 1:
        if not isPatchSet and not isX99:
            errMsg = common.getMsg(lang, "needInstallHotPatch.result.notPatchset.notX99", (patchDownPath, expectedVersionStr))
        elif isPatchSet and not isX99:
            errMsg = common.getMsg(lang, "needInstallHotPatch.result.isPatchset.notX99", (patchDownPath, expectedVersionStr, expectedVersionStr))
        elif not isPatchSet and isX99:
            errMsg = common.getMsg(lang, "needInstallHotPatch.result.notPatchset.isX99", (patchDownPath, expectedVersionStr))
        else :
            errMsg = common.getMsg(lang, "needInstallHotPatch.result.isPatchset.isX99", (patchDownPath, expectedVersionStr, expectedVersionStr))
    else:
        # 目前没有需要安装多个补丁的场景
        errMsg = common.getMsg(lang, "install.many.hotpatch", expectedVersionStr)
    return errMsg

