# -*- coding: UTF-8 -*-
from frame.cli import cliUtil
from frame.common import common
from frame.context import contextUtil

def execute(context):
    '''
    文件系统远程复制升级检查。
    '''
    LANG = contextUtil.getLang(context)
    LOGGER = common.getLogger(contextUtil.getLogger(context), __file__)
    cli = contextUtil.getSSH(context)
    cliRet = ""
    errMsg = ""
    curVersionLst = ["V300R002*", "V300R003C00", "V300R003C00SPC100", "V300R005*" ]  # *表示系列
    targetVersionLst = ["V300R003C10", "V300R003C10SPC100", "V300R003C20", "V300R003C20SPC100","V300R006C00" ]

    try:
        # CIFS共享配置检查版本范围
        curVersion = contextUtil.getCurVersion(context)
        targetVersion = contextUtil.getTargetVersion(context)
        LOGGER.logInfo("curVersion, targetVersion => %s, %s" % (curVersion, targetVersion))

        if not isMatchVersion(curVersion, curVersionLst) or not isMatchVersion(targetVersion, targetVersionLst):
            LOGGER.logInfo("the current version or the target version is check ok.")
            return common.getUpgEvaluationRs(True, cliRet, errMsg)

        cmd = "show remote_replication unified"
        LOGGER.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        cliRet = "%s" %checkRet[1]
        if checkRet[0] != True: 
            LOGGER.logSysAbnormal()
            errMsg = checkRet[2]
            return common.getUpgEvaluationRs(checkRet[0], cliRet, errMsg)
        
        if cliUtil.queryResultWithNoRecord(cliRet):
            LOGGER.logInfo("there is no record.")
            return common.getUpgEvaluationRs(True, cliRet, checkRet[2])
        
        cliRetLinesList = cliUtil.getHorizontalCliRet(checkRet[1])
        if len(cliRetLinesList) == 0:
            LOGGER.logNoPass("query result abnormal.")
            errMsg = common.getMsg(LANG, "query.result.abnormal")
            return common.getUpgEvaluationRs(cliUtil.RESULT_NOCHECK, cliRet, errMsg)

        for retDict in cliRetLinesList:
            fileType = retDict.get("Type")
            if "File System" == fileType:
                errMsg = common.getMsg(LANG, "replication.upgrade.check.notpass")
                LOGGER.logNoPass("The remote replication yype is File System.")
                return common.getUpgEvaluationRs(False, cliRet, errMsg)

        LOGGER.logPass()
        return common.getUpgEvaluationRs(True, cliRet, errMsg)
        
    except Exception, exception:
        LOGGER.logException(exception)
        return common.getUpgEvaluationRs(cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(LANG, "query.result.abnormal"))

def isMatchVersion(verFor, verList):
    '''
    @summary: 判断版本是否在列表范围
    '''
    for ver in verList:
        if verFor == ver:
            return True
        if ver[len(ver)-1] == '*':
            ver = ver[0:(len(ver)-1)]
            if (len(verFor) >= len(ver)) and verFor[0:len(ver)] == ver:
                return True
    return False