# -*- coding: UTF-8 -*-
from frame.common import common
from frame.cli import cliUtil
import AnalyzeRulesReader
from frame.common.regex import Regex


#----------------------------配置规则校验开始------------------------------
###equal、notEqual是字符串比较，greaterEqual、greater、lessEqual、less转换为float###
predict = {
    'equal': lambda head,value: equal(head,value),
    'notEqual': lambda head,value: notEqual(head,value),
    'greaterEqual': lambda head,value: greaterEqual(head,value),
    'greater' : lambda head,value: greater(head,value),
    'lessEqual': lambda head,value: lessEqual(head,value),
    'less' : lambda head,value: less(head,value),
}

def equal(head, value):
    if cmp(head,value) == 0:
        return True
    return False

def notEqual(head,value):
    if cmp(head,value) != 0:
        return True
    return False

def greaterEqual(head, value):
    if float(head) >= float(value):
        return True
    return False

def greater(head, value):
    if float(head) > float(value):
        return True
    return False

def lessEqual(head, value):
    if float(head) <= float(value):
        return True
    return False

def less(head, value):
    if float(head) < float(value):
        return True
    return False


#----------------------------配置比较类型开始------------------------------
ruleType = {
    'single': lambda head, logic, match, data, datasetsDict: single(head, logic, match, data, datasetsDict),
    'twoOper': lambda head, logic, match, data, datasetsDict: twoOper(head, logic, match, data, datasetsDict),
    'mulThenAdd': lambda head, logic, match, data, datasetsDict: mulThenAdd(head, logic, match, data, datasetsDict),
}

def single(head, logic, match, data, datasetsDict):
    headData = data[head]
    matchData = match
    return predict[logic](headData, matchData)

def twoOper(head, logic, match, data, datasetsDict):
    '''
    @summary: 适用于head数据需要进行二则运算后再进行规则计算的情况
    '''
    (operList, result) = Regex.split("[\+\-\*/]", head)
    oper = operList[0]
    
    headData = getTwoOperValue(oper, data[result[0]], data[result[1]]) 

    matchData = match
    return predict[logic](headData, matchData)

def mulThenAdd(head, logic, match, data, datasetsDict):
    headData = data[head]
    matchData = 0
    
    mulsGroups = match.split('+')
    for mulsGroup in mulsGroups:
        muls = mulsGroup.split('*')
        mulValue = 1
        
        for mul in muls:
            if mul.isdigit():
                mulValue *= float(mul)
                continue
            if data.get(mul) == None:
                mul = datasetsDict[mul]
            else:
                mul = data[mul]
            mulValue *= float(mul)
        matchData += mulValue
    
    return predict[logic](headData, matchData)

#--------------------------------------配置结束----------------------------------

def getTwoOperValue(oper, paramX, paramY):
    '''
    @summary: 获取二则运算的结果
    @param oper:运算符 
    '''
    value = {
              '-': lambda x, y : float(x) - float(y),
              '+': lambda x, y : float(x) + float(y),
              '*': lambda x, y : float(x) * float(y),
              '/': lambda x, y : float(x) / float(y),
            }[oper](paramX, paramY) 
    return value


def ruleMatch(nodeAttrDict, convertDataDict, titleAttrDict, datasetsDict, logger, lang):
    '''
    @summary: 每条rule规则的匹配
    '''
    flag = True
    errMsg = ""
    
    try:
        #批量获取rule里面各属性的值
        calType = nodeAttrDict.get("type")
        indexs = nodeAttrDict.get("index").split('.')
        fieldValue = nodeAttrDict.get("field")
        head = nodeAttrDict.get("head")
        logic = nodeAttrDict.get("logic")
        match = nodeAttrDict.get("value")
        output = nodeAttrDict.get("output")
        
        #根据index取对应数据表
        currentTableList = convertDataDict.get(indexs[0])
        exitFlag = False
        
        for data in currentTableList:
            #找到Name名称对应的行，判断规则
            if (data[indexs[1]] == fieldValue):
                exitFlag = True
                
                if ruleType[calType](head, logic, match, data, datasetsDict) != True:
                    flag = False
                    if output == None:
                        errMsg += common.getMsg(lang,"nooutput.not.match.rule" ,(titleAttrDict[indexs[0]],fieldValue,head))
                        logger.logNoPass("In table [%s]: Data item %s's value '%s' is abnormal." % (titleAttrDict[indexs[0]],fieldValue,head))
                    else:
                        outputData = data.get(output)
                        errMsg += common.getMsg(lang,"not.match.rule" ,
                                               (titleAttrDict[indexs[0]],output,outputData,fieldValue,head))
                        logger.logNoPass("In table [%s] which %s is %s: Data item %s's value '%s' is abnormal." %
                                   (titleAttrDict[indexs[0]],output,outputData,fieldValue,head))
                           
        if not exitFlag:
            logger.logInfo("[%s] : No Field Data(%s)." % (titleAttrDict[indexs[0]], fieldValue))
        
        return (flag, errMsg)    
    except Exception,ex:
        logger.logException(ex)
        raise Exception("ERROR00004", ex)
 
def renameDataStrDict(originalDataStrDict, titleAttrDict) :
    '''
    @summary: 以表名作为key读取config获取的表数据字典，转换为简称作为key的字典
    '''
    allDataStrDict = {}    
    nameList = titleAttrDict.keys()
    
    for name in nameList:
        title = titleAttrDict.get(name)
        allDataStrDict.setdefault(name, "".join(originalDataStrDict[title]))

    return allDataStrDict


def getAllTableStrDict(xmlInfo, dataAttrDict, localConfigFile, logger):
    '''
    @summary: 批量获取所有需要的数据,<datas>中的所有字段
    '''
    try:
        #取得name和title对应的字典
        titleAttrDict = dataAttrDict["title"]
        dataIds = titleAttrDict.values()
        
        originalDataStrDict = AnalyzeRulesReader.readConfigFile(dataAttrDict, localConfigFile, logger)

        #将解析出来的数据表对应别名
        allTableStrDict = renameDataStrDict(originalDataStrDict, titleAttrDict) 
        logger.logInfo("##allTableStrDict##: %s" % str(allTableStrDict))
        
        return allTableStrDict
    except Exception, ex:
        logger.logException(ex)
        raise Exception("ERROR00002", ex)
    
    
    
def getTableListByType(currentTableStr, anlyzeType):    
    '''
    @summary: 根据表格的形式，获取对应的list值;horizon是横向表格，vertical是竖向表格
    '''
    if anlyzeType == "horizon":
        currentTableList = AnalyzeRulesReader.getHorizontalRet(currentTableStr)
    elif anlyzeType == "vertical":
        currentTableList = AnalyzeRulesReader.getVerticalRet(currentTableStr)
    else:
        currentTableList = []
        
    return currentTableList

def converTableToList(currentTableStr, dataAttrDict, name, logger, lang):
    '''
    @summary: 根据表格的形式，获取对应的str&list值
    '''
    errMsg = ""
    
    try:  
        titleAttrDict = dataAttrDict.get("title")
        typeAttrDict = dataAttrDict.get("type")
        
        if len(currentTableStr) == 0:
            logger.logInfo("Can not get data table [%s]." % titleAttrDict[name])
            return (True, [], errMsg)
        
        anlyzeType =  typeAttrDict[name] 
        logger.logInfo("analyse type: [%s]" % anlyzeType)
        
        currentTableList = getTableListByType(currentTableStr, anlyzeType)
        logger.logInfo("currentTable: [%s]; currentTableList: %s" % (name,str(currentTableList)))
        
        if len(currentTableList) == 0:
            errMsg = common.getMsg(lang,"abnormal.data.content")
            logger.logInfo("Abnormal original information." )
            return (cliUtil.RESULT_NOCHECK, [], errMsg)
        
        return (True, currentTableList, errMsg)
    except Exception, ex:
        logger.logException(ex)
        raise Exception("ERROR00003", ex)


def getDatasetsDict(datasetsXml, localConfigFile, logger):
    '''
    @summary: 获取<datasets>中的所有结点的数据值，构成字典
    '''
    try: 
        datasetsAttrXml = [dataset['elementAttrbutes'] for dataset in datasetsXml]
        names = [datasetsAttr["name"] for datasetsAttr in datasetsAttrXml]
        titles = [datasetsAttr["title"] for datasetsAttr in datasetsAttrXml]
        fields = [datasetsAttr["field"] for datasetsAttr in datasetsAttrXml]
        
        datasetsDict = AnalyzeRulesReader.getDatasetsFromConf(names, titles, fields, localConfigFile)
        logger.logInfo("##datasetsDict##:%s" % str(datasetsDict) )
        return datasetsDict
           
    except Exception, ex:
        logger.logException(ex)
        raise Exception("ERROR00005", ex)




