# -*- coding: UTF-8 -*-
#该配置脚本只在frame框架中使用
from frame.rest import restData

HIGH_END_DEVS = ["18500 V3", "18500F V3", "18800 V3", "18800F V3", "18500 V5", "18500F V5", "18800 V5", "18800F V5"]
ARM_DEVS = ["2100 V3", "2200 V3", "2600 V3", "2600F V3", "5100 V3", "5300 V5", "5500 V5 Elite", "2200 V3 Enhanced", "2600 V3 Enhanced", "2600F V3 Enhanced", "5300 V5 Enhanced"]
ARM_DEVS_2U = ["2100 V3", "2200 V3", "2600 V3", "2600F V3", "5300 V5", "5500 V5 Elite", "2200 V3 Enhanced", "2600 V3 Enhanced", "2600F V3 Enhanced", "5300 V5 Enhanced"]
#Dorado 系列型号
DORADO_DEVS = ["Dorado3000 V3", "Dorado5000 V3", "Dorado6000 V3", "Dorado18000 V3"]
DORADO_NAS_DEVS = ["Dorado NAS"]
CTRL_6U_PRODUCTS = ["6800 V3","6800F V3","18500 V3","18500F V3","18800 V3","18800F V3","6800 V5","6800F V5","18500 V5","18500F V5","18800 V5","18800F V5"]
SVP_REST_IP='172.17.126.11'

REST_BASE_URI = r"https://%s:%s/deviceManager/rest/%s/"
REST_DEFAULT_PORT = "8088"
RETRY_TIMES = 3 #rest重试次数
ERR_CODE_SLAVE_NODE_HANDLE_MSG_IGNORE = "1089101853"
REST_DEFAULT_ERR_CODE = "0"
COMMUNICATION_FAIL_ERROR_CODE = [
     "16797697", #与设备断开连接
     "1073949185", #与设备通信异常，请检查网络连接或设备状态是否正常
     "16797698",    #与设备通信异常
]


ERR_CODE_NOT_EXIST = "1077948996" #Error Code=1077948996, Description=指定的对象不存在。
CONTROLLER_PAIR = {  
                   "A" : "B",
                   "B" : "A",
                   "C" : "D",
                   "D" : "C",
    }

NODE_ID_MAP = {
                    "A":0,
                    "B":1,
                    "C":2,
                    "D":3,
                } 
#检查业务压力相关参数
CHECK_SYS_PRESSURE_PERIOD = 1    #检查周期（秒）
CHECK_SYS_PRESSURE_TIMES = 30   #检查业务压力的总次数
CHECK_SUCCESS_RATE = 0.3    #检查成功达标率
MAX_CPUUSAGE_PER_CTRL = 40  #单个控制器允许最大CPU利用率

g_frontEndIntfModels = (#所有的前端接口model
                        1, #4x4G FC接口模块
                        2, #2x4G FC接口模块
                        3, #2xGE 电接口模块
                        5, #Swapped FC接口模块
                        6, #2x10GE 光接口模块
                        7, #1x8G FC光接口模块
                        8, #2x8G FC光接口模块
                        11, #2xFC+2xGE 接口模块
                        12, #4xGE 电接口模块
                        13, #4x8G FC光接口模块
                        21, #4x10G FCoE光接口模块
                        25, #4x10GE接口模块
                        27, #2x10G FCoE光接口模块
                        28, #4xGE光接口模块
                        29, #2x16G FC光接口模块
                        31, #4x10GE 电接口模块
                        32, #2x40GE IB接口模块
                        33, #2x56GE IB接口模块
                        34, #4xGE 电接口模块
                        36, #4x10GE 电接口模块
                        37, #4xSmart 光接口模块
                        38, #8x8G FC光接口模块
                        39, #4x8G FC光接口卡
                        40#4x16G FC光接口卡
                        )

class IpTypeEnum():
    IPV4 = 0
    IPV6 = 1

#离线控制器相关参数
OFFLINE_CTRL_TIMEOUT = 300
OFFLINE_SINGLE_CTRL_TIMEOUT = 900 #离线轮训检查时间,停虚拟机5分钟，下电10分钟。
OFFLINE_CTRL_INTERVAL = 5

# cli_software_hcDlmCheckBefore对应补丁提示
HOT_PATCH_DICT = {"V300R006C10SPC100": "V300R006C10SPH101",
                  "V500R007C00SPC100": "V500R007C00SPH101"}