# -*- coding: UTF-8 -*-

#BBU满配规格，键表示设备类型，值表示单个引擎下BBU的满配规格
BBU_OF_ENGINE_CONFIG_DICT = {
    "S2600T": 2,
    "S5500T": 2,
    "S5600T": 4,
    "S5800T": 4,
    "S6800T": 4,
    "2100 V3": 2,
    "2200 V3": 2,
    "2600 V3": 2,
    "2600 V3 for Video": 2,
    "2600F V3": 2,
    "2800 V3": 2,
    "5300 V3": 2,
    "5500 V3": 2,
    "5500F V3": 2,
    "5600 V3": 2,
    "5600F V3": 2,
    "5800 V3": 3,
    "5800F V3": 3,
    "6800 V3": 4,
    "6800F V3": 4,
    "6900 V3": 4,
    "HVS85T": 4,
    "HVS88T": 4,
    "18500": 4,
    "18800": 4,
    "18800F": 4,
    "18500 V3": 4,
    "18500F V3": 4,
    "18800 V3": 4,
    "18800F V3": 4,
    "Dorado18000 V3": 4,
    "Dorado6000 V3": 4,
    "Dorado6000_V3": 4,  # Dorado6000 C21普通版内部型号，规格改为3+1，
    "Dorado6000E_V3": 3,  # Dorado6000 C21增强版内部型号，规格改为2+1，
    "Dorado5000 V3": 2,
    "Dorado3000 V3": 2,
    "2800 V5": 2,
    "5110 V5": 2,
    "5100K V5": 2,
    "5110F V5": 2,
    "5210 V5": 2,
    "5200K V5": 2,
    "5210F V5": 2,
    "5300 V5": 2,
    "5500 V5 Elite": 2,
    "5500 V5": 2,
    "Dorado NAS": 2,
    "5600 V5": 3,
    "5800 V5": 3,
    "6800 V5": 4,
    "18500 V5": 4,
    "18800 V5": 4,
    "5300F V5": 2,
    "5500F V5": 2,
    "5600F V5": 2,
    "5800F V5": 3,
    "6800F V5": 4,
    "18500F V5": 4,
    "18800F V5": 4,
    "2200 V3 Enhanced": 2,
    "2600 V3 Enhanced": 2,
    "2600F V3 Enhanced": 2,
    "5300 V5 Enhanced": 2,
}

#风扇满配规格,键[1]表示框类型，键[2]表示高度(U)，键[4]表示是否为高密框，值表示风扇个数
FAN_CONFIG_DICT = {
("ENG", "2", "--"):2,#2U引擎框
("CTE", "2", "--"):2,#2U引擎框
("ENG", "3", "--"):6,#3U引擎框
("CTE", "3", "--"):6,#3U引擎框
("ENG", "4", "--"):3,#4U引擎框（盘框一体）
("CTE", "4", "--"):3,#4U引擎框（盘框一体）
("DAE", "2", "--"):2,#2U普通硬盘框
("DAE", "4", "high-density"):2,#4U高密硬盘框
("DAE", "4", "--"):4,#4U普通硬盘框
("DSW", "1", "--"):2,#PCIe交换框
}

#检查项所涉及的产品版本，如果都涉及则为ALL
CHECK_ITEMS_INVOLVED_VERSIONS = {
    "check_cli_service_alsLinkStatus":[
                                        "V100R001C20",
                                        "V100R001C20B013",
                                        "V100R001C20LNLT01",
                                        "V100R001C20SPC100",
                                        "V100R001C20SPC200",
                                        "V300R001C10",
                                        "V300R001C10B012",
                                        "V300R001C10SPC100",
                                        "V300R001C10SPC200",
                                        "V300R002C00",
                                        "V300R002C00SPC100",
                                        "V300R002C10",
                                        "V200R002C20",
                                        "V200R002C20B013",
                                        "V200R002C20SPC200",
                                        ],
    "check_cli_service_NFSsharedFault":[
                                         "V300R002C10", 
                                         "V300R002C10SPC100",
                                        ],
    "check_cli_service_IPv6LockService":[
                                          "V300R002C00",
                                          "V300R002C00SPC100",
                                          "V300R002C10",
                                          "V300R002C10SPC100",
                                        ],
    "check_cli_service_iSNSIPv6Service":[
                                        "V100R001C20",
                                        "V100R001C20B013",
                                        "V100R001C20LNLT01",
                                        "V100R001C20SPC100",
                                        "V100R001C20SPC200",
                                        "V300R001C10",
                                        "V300R001C10B012",
                                        "V300R001C10SPC100",
                                        "V300R001C10SPC200",
                                        "V300R002C00",
                                        "V300R002C00SPC100",
                                        "V200R002C20",
                                        "V200R002C20B013",
                                        "V200R002C20SPC200",
                                        ],
    "check_cli_service_ioStatus":["ALL"],
    "check_cli_service_cachePartitionFaultPage":["ALL"],
    "check_cli_service_ioDetect":[
                                 "V100R001C30SPC200",
                                 "V200R002C30SPC200",
                                 "V300R001C20SPC200",
                                 ],                                            
}

# 风险路径字典元组
RISK_VERSION_PATH = (
                     {"curVersion":"V300R001C20SPC100", "upgradePkgVersion":"V300R002C10SPC100"},
                     {"curVersion":"V300R001C20SPC100", "upgradePkgVersion":"V300R002C10SPC200"},
                     {"curVersion":"V300R001C20", "upgradePkgVersion":"V300R002C10SPC100"},
                     {"curVersion":"V300R001C20", "upgradePkgVersion":"V300R002C10SPC200"},
                     {"curVersion":"V300R001C10B012", "upgradePkgVersion":"V300R001C20SPC200"},
                     )

#某类告警id的告警全集配置字典
alarmIdDict = {
"encloSigLinkAlarm":['0xF00CE002A'],               
"intfCardAlarm":['0xF0D10006', '0xF00D10020', '0xF00D1003D', '0xF0D10008'],
"casecadeAlarm":['0xF0050003', '0xF00D00018'],
"ctrlFaultAlarm":['0xF0CF0003', '0xF00CF005F','0xF00CF0068'],
"diskSigLinkAlarm":['0xF00A000C', '0xF000A0112'],
"diskDomainInternalResourceAlarm":['0xF010A0057'],
}

SERIES_T = "T_SERIES"
SERIES_V3 = "V3_SERIES"
SERIES_ARM = "ARM_SERIES"
SERIES_Dorado = "Dorado_SERIES"
SERIES_18000V3 = "18000V3_SERIES"
SERIES_18000 = "18000_SERIES"
SERIES_68V5 = "68V5_SERIES"

STOR_DEV_INFO_DICT = {
    "S2600T": SERIES_T,
    "S5500T": SERIES_T,
    "S5600T": SERIES_T,
    "S5800T": SERIES_T,
    "S6800T": SERIES_T,
    "2100 V3": SERIES_ARM,
    "2200 V3": SERIES_ARM,
    "2600 V3": SERIES_ARM,
    "2600 V3 for Video": SERIES_ARM,
    "2600F V3": SERIES_ARM,
    "2800 V3": SERIES_V3,
    "5300 V3": SERIES_V3,
    "5500 V3": SERIES_V3,
    "5500F V3": SERIES_V3,
    "5600 V3": SERIES_V3,
    "5600F V3": SERIES_V3,
    "5800 V3": SERIES_V3,
    "5800F V3": SERIES_V3,
    "6800 V3": SERIES_V3,
    "6800F V3": SERIES_V3,
    "6900 V3": SERIES_V3,
    "2800 V5": SERIES_V3,
    "5110 V5": SERIES_ARM,
    "5100K V5": SERIES_ARM,
    "5110F V5": SERIES_ARM,
    "5210 V5": SERIES_ARM,
    "5200K V5": SERIES_ARM,
    "5210F V5": SERIES_ARM,
    "5300 V5": SERIES_ARM,
    "5500 V5 Elite": SERIES_ARM,
    "5500 V5": SERIES_V3,
    "Dorado NAS": SERIES_V3,
    "5600 V5": SERIES_V3,
    "5800 V5": SERIES_V3,
    "6800 V5": SERIES_68V5,
    "5300F V5": SERIES_V3,
    "5500F V5": SERIES_V3,
    "5600F V5": SERIES_V3,
    "5800F V5": SERIES_V3,
    "6800F V5": SERIES_68V5,
    'Dorado3000 V3': SERIES_Dorado,
    'Dorado5000 V3': SERIES_Dorado,
    'Dorado6000 V3': SERIES_Dorado,
    'Dorado18000 V3': SERIES_Dorado,
    "HVS85T": SERIES_18000,
    "HVS88T": SERIES_18000,
    "18500": SERIES_18000,
    "18800": SERIES_18000,
    "18800F": SERIES_18000,
    "18500 V3": SERIES_18000V3,
    "18500F V3": SERIES_18000V3,
    "18800 V3": SERIES_18000V3,
    "18800F V3": SERIES_18000V3,
    "18500 V5": SERIES_18000V3,
    "18800 V5": SERIES_18000V3,
    "18500F V5": SERIES_18000V3,
    "18800F V5": SERIES_18000V3,
    "2200 V3 Enhanced": SERIES_ARM,
    "2600 V3 Enhanced": SERIES_ARM,
    "2600F V3 Enhanced": SERIES_ARM,
    "5300 V5 Enhanced": SERIES_ARM,
}

##---------18000 V3高端不配套硬盘的编码黑名单，共56个-----------##
DISK_BLACK_ITEMS = ['02350RRF', '02350WLE', '02350RRH', '02350WLG', '02350PMF', '02350SQN', 
                   '02350JDA', '02350JDF', '02350BVU', '02350NWU', '02359658', '02350NWY', 
                   '02350EEM', '02350NXB', '02350SQP', '02350NXE', '02350RTF', '02350RTP', 
                   '02358406', '02358407', '02350HGL', '02358408', '02350CDV', '02350HGM', 
                   '02350GDA', '02350ECX', '02350ECY', '02359659', '02359660', '02358403', 
                   '02359657', '02358404', '02350HGG', '02350EDL', '02350HGJ', '02350MQG', 
                   '02350CAW', '02350CAY', '02350CBA', '02350CBB', '02350CBC', '02350CBD', 
                   '02350CBE', '02350CBF', '02350DXU', '02350DXV', '02350STQ', '02350STR', 
                   '02350GMR', '02350GMP', '02350VVE', '02350VVF', '02350LGX', '02350LHE', 
                   '02350LGY', '02350LHF' 
                   ]



#需要检查内部型号的版本
NEED_CHECK_INTERNAL_PRODUCT_MODEL_VERSION = "V300R001C21"

# Doraodo6000 V3
SPECIAL_BBU_CONFIG_PDT_MODEL = "Dorado6000 V3"

# check_tlv_software_sysResource检查项阈值为180M,200M,270M,400M的设备
MEMORY_DEVS_180 = ["2100 V3", "2200 V3", "2200 V3 Enhanced",
                   "2600 V3 Enhanced", "2600 V3", "2600F V3",
                   "2600F V3 Enhanced", "2600 V3 for Video", "2800 V3",
                   "2800 V5", "5100 V3", "5300 V3",
                   "5110 V5", "5100K V5", "5110F V5", "5210 V5", "5200K V5",
                   "5210F V5", "5300 V5",
                   "5300F V5", "5300 V5 Enhanced"]
MEMORY_DEVS_200 = ["S2600T", "S5500T", "5500 V3", "5500 V5", "5500 V5 Elite", "5500F V3", "5500F V5", "Dorado NAS"]
MEMORY_DEVS_270 = ["5600 V3", "5600F V3", "5600 V5", "5600F V5", "5800 V3", "5800F V3",
                   "5800 V5", "5800F V5", "6800 V3", "6800F V3", "6800 V5", "6800F V5"]
MEMORY_DEVS_400 = ["18500 V3", "18500F V3", "18500 V5", "18500F V5", "18800 V3", "18800F V3",
                   "18800 V5", "18800F V5"]

# 端口漂移白名单
HBA_WHITE_LIST = ['HBA:FV2.01A13 DV8.3.5.48.2p',
'HBA:HPAJ764A FW:v5.06.03 DVR:v8.03.07.07-k',
'HBA:Emulex SN1100E2P FV10.2.340.19 DV8.3.5.48.2p',
'HBA:Emulex LPe12002-M8 FV2.01A10 DV8.3.7.10.6p',
'HBA:Emulex LPe1250-F8 FV2.01A13 DV8.3.7.10.6p',
'HBA:Emulex LPe16002B-M6 FV10.4.255.23 DV8.3.7.10.6p',
'HBA:QLE2562 FW:v5.08.00 DVR:v8.04.00.13.11.3-k',
'HBA:QLE2672 FW:v7.03.00 DVR:v8.04.00.13.11.3-k',
'HBA:HPAJ764A FW:v5.08.00 DVR:v8.04.00.13.11.3-k',
'HBA:Emulex AJ763A/AH403A FV1.00A12 DV8.3.7.10.6p',
'HBA:Emulex SN1100E2P FV10.2.340.19 DV8.3.7.10.6p',
'HBA:Emulex LPe1250-F8 FV2.01A13 DV10.4.8000.0',
'HBA:Emulex LPe16002B-M6 FV10.4.255.23 DV10.4.8000.0.',
'HBA:QLE2562 FW:v8.00.00 DVR:v8.07.00.18-k',
'HBA:HPAJ764A FW:v8.00.00 DVR:v8.07.00.18-k',
'HBA:Emulex SN1100E2P FV10.2.340.19 DV10.4.8000.0.',
'HBA:Emulex LPe12002-M8 FV2.01A10 DV10.2.8040.1',
'HBA:Emulex LPe1250-F8 FV2.01A13 DV10.2.8040.1',
'HBA:Emulex LPe16002B-M6 FV10.4.255.23 DV10.2.8040.1',
'HBA:QLE2562 FW:v7.03.00 DVR:v8.07.00.08.12.0-k',
'HBA:QLE2672 FW:v7.03.00 DVR:v8.07.00.08.12.0-k',
'HBA:HPAJ764A FW:v7.03.00 DVR:v8.07.00.08.12.0-k',
'HBA:Emulex AJ763A/AH403A FV1.00A12 DV10.2.8040.1',
'HBA:Emulex SN1100E2P FV10.2.340.19 DV10.2.8040.1',
'HBA:Emulex LPe12002-M8 FV2.01A10 DV10.5.0.2 HN:linux-t6p1 OS:Linux',
'HBA:Emulex LPe1250-F8 FV2.01A13 DV10.5.0.2 HN:linux-966q OS:Linux',
'HBA:Emulex LPe16002B-M6 FV10.4.255.23 DV10.5.0.2 HN:linux-5cq1 OS:Linux',
'HBA:QLE2562 FW:v7.03.00 DVR:v8.07.00.18-k',
'HBA:QLE2672 FW:v7.03.00 DVR:v8.07.00.18-k',
'HBA:HPAJ764A FW:v7.03.00 DVR:v8.07.00.18-k',
'HBA:Emulex AJ763A/AH403A FV1.00A12 DV10.5.0.2 HN:linux-6r93 OS:Linux',
'HBA:Emulex SN1100E2P FV10.2.340.19 DV10.5.0.2 HN:linux-6r93 OS:Linux',
'HBA:Emulex LPe1250-F8 FV2.01A13 DV11.1.0.1. HN:linux OS:Linux',
'HBA:Emulex LPe16002B-M6 FV10.4.255.23 DV11.1.0.1. HN:linux OS:Linux',
'HBA:QLE2672 FW:v7.03.00 DVR:v8.07.00.33-k',
'HBA:Emulex LPe12002-M8 FV2.01A10 DV11.4.0.1. HN:linux. OS:Linux',
'HBA:HPAJ764A FW:v8.04.00 DVR:v8.07.00.33-k',
'HBA:SN1100Q FW:v8.05.61 DVR:v8.07.00.33-k',
'HBA:Emulex SN1100E2P FV10.2.340.19 DV11.1.0.1. HN:linux OS:Linux',
'HBA:Emulex LPe12002-M8 FV2.01A10 DV11.4.0.1. HN:linux. OS:Linux',
'HBA:Emulex LPe1250-F8 FV2.01A13 DV11.4.0.1',
'HBA:Emulex LPe16002B-M6 FV10.4.255.23 DV11.4.0.1. HN:linux. OS:Linux',
'HBA:Emulex LPe31002-M6 FV11.2.156.27 DV11.4.0.1.',
'HBA:Emulex AJ763A/AH403A FV1.00A12 DV11.4.0.1. HN:linux. OS:Linux',
'HBA:Emulex SN1100E2P FV10.2.340.19 DV11.4.0.1. HN:linux. OS:Linux',
'HBA:Emulex LPe12002    FV2.01A11 DV8.3.5.86.1p',
'HBA:Emulex LPe1250-F8 FV2.01A13 DV8.3.5.86.1p',
'HBA:QLE2562 FW:v5.08.00 DVR:v8.04.00.08.06.4-k',
'HBA:QLE2672 FW:v7.03.00 DVR:v8.04.00.08.06.4-k',
'HBA:HPAJ764A FW:v5.08.00 DVR:v8.04.00.08.06.4-k',
'HBA:Emulex SN1100E2P FV10.2.340.19 DV8.3.5.86.1p',
'HBA:Emulex LPe1250-F8 FV2.01A13 DV8.3.7.21.4p',
'HBA:QLE2672 FW:v7.03.00 DVR:v8.05.00.03.06.5-k2',
'HBA:HPAJ764A FW:v7.00.01 DVR:v8.05.00.03.06.5-k2',
'HBA:Emulex SN1100E2P FV10.2.340.19 DV8.3.7.21.4p',
'HBA:Emulex LPe12002    FV2.01A11 DV10.2.8020.1',
'HBA:Emulex LPe1250-F8 FV2.01A13 DV10.2.8020.1',
'HBA:QLE2562 FW:v7.03.00 DVR:v8.07.00.08.06.6-k1',
'HBA:QLE2672 FW:v7.03.00 DVR:v8.07.00.08.06.6-k1',
'HBA:HPAJ764A FW:v7.03.00 DVR:v8.07.00.08.06.6-k1',
'HBA:Emulex SN1100E2P FV10.2.340.19 DV10.2.8020.1',
'HBA:Emulex LPe1250-F8 FV2.01A13 DV10.6.0.20',
'HBA:HPAJ764A FW:v7.03.00 DVR:v8.07.00.16.06.7-k',
'HBA:Emulex SN1100E2P FV10.2.340.19 DV10.6.0.20 HN:(none) OS:Linux',
'HBA:Emulex LPe12002    FV2.01A11 DV11.0.0.4 HN:(none) OS:Linux',
'HBA:Emulex LPe1250-F8 FV2.01A13 DV11.0.0.4',
'HBA:Emulex LPe31002-M6 FV11.2.156.27 DV11.0.0.4',
'HBA:QLE2672 FW:v7.03.00 DVR:v8.07.00.26.06.8-k',
'HBA:QLE2692 FW:v8.03.04 DVR:v8.07.00.26.06.8-k',
'HBA:SN1100Q FW:v8.05.61 DVR:v8.07.00.26.06.8-k',
'HBA:HPAJ764A FW:v7.03.00 DVR:v8.07.00.26.06.8-k',
'HBA:Emulex AJ763A/AH403A FV1.00A12 DV11.0.0.4 HN:(none) OS:Linux',
'HBA:Emulex SN1100E2P FV10.2.340.19 DV11.0.0.4 HN:(none) OS:Linux',
'HBA:Emulex LPe1250-F8 FV2.01A13 DV11.0.0.5',
'HBA:QLE2672 FW:v7.03.00 DVR:v8.07.00.26.06.8-k',
'HBA:HPAJ764A FW:v7.03.00 DVR:v8.07.00.26.06.8-k',
'HBA:SN1100Q FW:v8.05.61 DVR:v8.07.00.26.06.8-k',
'HBA:Emulex SN1100E2P FV10.2.340.19 DV11.0.0.5 HN:(none) OS:Linux',
'HBA:Emulex LPe12002-M8 FV2.01A10 DV8.3.7.34.3p',
'HBA:Emulex LPe1250-F8 FV2.01A13 DV8.3.7.34.3p',
'HBA:QLE2562 FW:v7.01.00 DVR:v8.06.00.08.07.0-k2',
'HBA:QLE2672 FW:v7.03.00 DVR:v8.06.00.08.07.0-k2',
'HBA:HPAJ764A FW:v7.01.00 DVR:v8.06.00.08.07.0-k2',
'HBA:Emulex AJ763A/AH403A FV1.00A12 DV8.3.7.34.3p',
'HBA:Emulex SN1100E2P FV10.2.340.19 DV8.3.7.34.3p',
'HBA:Emulex LPe12002-M8 FV2.01A10 DV10.2.8021.1',
'HBA:Emulex LPe1250-F8 FV2.01A13 DV10.2.8021.1',
'HBA:QLE2562 FW:v7.03.00 DVR:v8.07.00.08.07.1-k2',
'HBA:QLE2672 FW:v7.03.00 DVR:v8.07.00.08.07.1-k2',
'HBA:HPAJ764A FW:v7.03.00 DVR:v8.07.00.08.07.1-k2',
'HBA:Emulex AJ763A/AH403A FV1.00A12 DV10.2.8021.1',
'HBA:Emulex SN1100E2P FV10.2.340.19 DV10.2.8021.1',
'HBA:Emulex LPe12002-M8 FV2.01A10 DV10.7.0.1 HN:localhost.localdomain OS:Linux',
'HBA:Emulex LPe1250-F8 FV2.01A13 DV10.7.0.1',
'HBA:Emulex LPe16002B-M6 FV11.1.217.0 DV10.7.0.1 HN:localhost.localdomain OS:Linux',
'HBA:QLE2562 FW:v7.03.00 DVR:v8.07.00.18.07.2-k',
'HBA:QLE2672 FW:v7.03.00 DVR:v8.07.00.18.07.2-k',
'HBA:HPAJ764A FW:v7.03.00 DVR:v8.07.00.18.07.2-k',
'HBA:Emulex AJ763A/AH403A FV1.00A12 DV10.7.0.1 HN:localhost.localdomain OS:Linux',
'HBA:Emulex SN1100E2P FV10.2.340.19 DV10.7.0.1 HN:localhost.localdomain OS:Linux',
'HBA:Emulex LPe1250-F8 FV2.01A13 DV11.1.0.2',
'HBA:Emulex LPe31002-M6 FV11.2.156.27 DV11.1.0.2',
'HBA:QLE2672 FW:v7.03.00 DVR:v8.07.00.33.07.3-k1',
'HBA:SN1100Q FW:v8.05.61 DVR:v8.07.00.33.07.3-k1',
'HBA:Emulex AJ763A/AH403A FV1.00A12 DV11.1.0.2 HN:localhost.localdomain OS:Linux',
'HBA:Emulex SN1100E2P FV10.2.340.19 DV11.1.0.2 HN:localhost.localdomain OS:Linux',
'HBA:Emulex LPe12002-M8 FV2.01A10 DV11.2.0.6 HN:localhost.localdomain OS:Linux',
'HBA:Emulex LPe12002    FV2.01A11 DV11.2.0.6 HN:localhost.localdomain OS:Linux',
'HBA:Emulex LPe1250-F8 FV2.01A13 DV11.2.0.6',
'HBA:Emulex LPe31002-M6 FV11.2.156.27 DV11.2.0.6',
'HBA:QLE2562 FW:v8.06.00 DVR:v8.07.00.38.07.4-k1',
'HBA:QLE2672 FW:v7.03.00 DVR:v8.07.00.38.07.4-k1',
'HBA:HPAJ764A FW:v8.06.00 DVR:v8.07.00.38.07.4-k1',
'HBA:SN1100Q FW:v8.05.61 DVR:v8.07.00.38.07.4-k1',
'HBA:Emulex SN1100E2P FV10.2.340.19 DV11.2.0.6 HN:localhost.localdomain OS:Linux',
'HBA:Emulex LPe1250-F8 FV2.01A13 DV11.4.0.4.',
'HBA:Emulex LPe16002B-M6 FV10.4.255.23 DV11.4.0.4. HN:localhost.localdomain. OS:Linux',
'HBA:Emulex LPe31002-M6 FV11.2.156.27 DV11.4.0.4',
'HBA:Emulex AJ763A/AH403A FV1.00A12 DV11.4.0.4',
'HBA:Emulex SN1100E2P FV10.2.340.19 DV11.4.0.4',
'HBA:Emulex LPe1250-F8 FV2.01A13 DV8.2.2.1-18vmw',
'HBA:QLE2562 FW:v5.06.05 DVR:v934.5.4.0-1vmw',
'HBA:Emulex LPe12002-M8 FV2.01A10 DV8.2.3.1-127vmw',
'HBA:Emulex LPe1250-F8 FV2.01A13 DV8.2.3.1-127vmw',
'HBA:Emulex LPe12002-M8 FV2.01A10 DV8.2.3.1-127vmw',
'HBA:Emulex LPe1250-F8 FV2.01A13 DV8.2.3.1-127vmw',
'HBA:Emulex LPe16002B-M6 FV11.2.156.27 DV8.2.3.1-127vmw',
'HBA:Emulex LPe1250-F8 FV2.01A13 DV8.2.3.1-127vmw',
'HBA:Emulex AJ763A/AH403A FV1.00A12 DV8.2.3.1-127vmw',
'HBA:Emulex SN1100E2P FV10.2.340.19 DV8.2.3.1-127vmw',
'HBA:Emulex LPe12002-M8 FV2.01A10 DV10.0.100.1',
'HBA:Emulex LPe1250-F8 FV2.01A13 DV10.0.100.1',
'HBA:Emulex LPe16002B-M6 FV10.4.255.23 DV10.0.100.1',
'HBA:QLE2562 FW:v5.09.00 DVR:v1.0.12.0',
'HBA:QLE2672 FW:v7.03.00 DVR:v1.0.12.0',
'HBA:Emulex LPe12002-M8 FV2.01A10 DV10.0.100.1',
'HBA:QLE2562 FW:v5.09.00 DVR:v1.0.12.0',
'HBA:QLE2672 FW:v7.03.00 DVR:v1.0.12.0',
'HBA:HPAJ764A FW:v5.09.00 DVR:v1.0.12.0',
'HBA:Emulex AJ763A/AH403A FV1.00A12 DV10.0.100.1',
'HBA:Emulex SN1100E2P FV10.2.340.19 DV10.0.100.1',
'HBA:Emulex LPe1250-F8 FV2.01A13 DV10.2.309.8',
'HBA:Emulex LPe12002    FV2.01A11 DV10.2.309.8',
'HBA:Emulex LPe1250-F8 FV2.01A13 DV10.2.309.8',
'HBA:QLE2562 FW:v7.02.00 DVR:v2.0.12.0',
'HBA:QLE2562 FW:v8.07.00 DVR:v2.1.73.0',
'HBA:QLE2692 FW:v8.03.04 DVR:v2.1.73.0',
'HBA:HPAJ764A FW:v7.02.00 DVR:v2.0.12.0',
'HBA:Emulex AJ763A/AH403A FV1.00A12 DV10.2.309.8',
'HBA:Emulex SN1100E2P FV10.2.340.19 DV10.2.309.8',
'HBA:Emulex LPe1250-F8 FV2.01A13 DV10.2.309.8',
'HBA:Emulex LPe16002B-M6 FV11.2.156.27 DV11.0.237.0 HN:localhost OS:VMware ESXi 6.0.0',
'HBA:Emulex LPe16002B-M6 FV11.2.156.27 DV11.2.266.0 HN:localhost OS:VMware ESXi 6.0.0',
'HBA:QLE2562 FW:v8.05.00 DVR:v2.1.65.0',
'HBA:Emulex AJ763A/AH403A FV1.00A12 DV10.2.309.8',
'HBA:Emulex SN1100E2P FV10.2.340.19 DV10.2.309.8',
'HBA:Emulex LPe12002    FV2.01A11 DV11.1.0.6 HN:localhost OS:VMware ESXi 6.5.0',
'HBA:Emulex LPe1250-F8 FV2.01A13 DV11.1.0.6 HN:localhost OS:VMware ESXi 6.5.0',
'HBA:Emulex LPe16002B-M6 FV11.1.217.0 DV11.1.0.6 HN:localhost OS:VMware ESXi 6.5.0',
'HBA:Emulex LPe31002-M6 FV11.2.156.27 DV11.1.0.6 HN:localhost OS:VMware ESXi 6.5.0',
'HBA:QLE2562 FW:v8.01.02 DVR:v2.1.30.0',
'HBA:QLE2562 FW:v8.07.00 DVR:v2.1.73.0',
'HBA:QLE2692 FW:v8.03.04 DVR:v2.1.73.0',
'HBA:Emulex LPe16002B-M6 FV11.1.217.0 DV11.4.33.1 HN:localhost OS:VMware ESXi 6.5.0',
'HBA:Emulex LPe31002-M6 FV11.2.156.27 DV11.4.33.1',
'HBA:QLE2692 FW:v8.03.04 DVR:v2.1.50.0',
'HBA:SN1100Q FW:v8.05.61 DVR:v2.1.50.0',
'HBA:Emulex SN1100E2P FV10.2.340.19 DV11.4.33.1 HN:localhost OS:VMware ESXi 6.5.0',
'HBA:Emulex LPe12002    FV2.01A11 DV11.4.33.1 HN:localhost OS:VMware ESXi 6.7.0',
'HBA:Emulex LPe1250-F8 FV2.01A13 DV11.4.33.1',
'HBA:Emulex LPe16002B-M6 FV11.1.217.0 DV11.4.33.1 HN:localhost OS:VMware ESXi 6.7.0',
'HBA:QLE2562 FW:v8.05.00 DVR:v3.0.1.0',
'HBA:QLE2672 FW:v7.03.00 DVR:v3.0.1.0',
'HBA:QLE2692 FW:v8.03.04 DVR:v3.0.1.0',
'HBA:SN1100Q FW:v8.05.61 DVR:v3.0.1.0',
'HBA:HPAJ764A FW:v8.05.00 DVR:v3.0.1.0',
'HBA:Emulex SN1100E2P FV10.2.340.19 DV11.4.33.1',
'HBA:Emulex LPe12002-M8 FV2.01A10 DV8.3.7.18',
'HBA:Emulex LPe1250-F8 FV2.01A13 DV8.3.7.18',
'HBA:QLE2562 FW:v5.08.00 DVR:v8.04.00.13.11.3-k',
'HBA:QLE2672 FW:v7.03.00 DVR:v8.04.00.13.11.3-k',
'HBA:Emulex LPe1250-F8 FV2.01A13 DV8.3.7.18',
'HBA:QLE2672 FW:v7.03.00 DVR:v8.06.00.10.11.1-k',
'HBA:Emulex LPe1250-F8 FV2.01A13 DV10.6.133.8',
'HBA:QLE2672 FW:v7.03.00 DVR:v8.06.00.10.11.1-k',
'HBA:Emulex LPe12002-M8 FV2.01A10 DV10.6.133.8 HN:(none) OS:Linux',
'HBA:Emulex LPe12002    FV2.01A11 DV10.6.133.8 HN:(none) OS:Linux',
'HBA:Emulex LPe1250-F8 FV2.01A13 DV10.6.133.8',
'HBA:QLE2562 FW:v5.08.00 DVR:v8.06.00.10.11.1-k',
'HBA:QLE2672 FW:v7.03.00 DVR:v8.06.00.10.11.1-k',
'HBA:Emulex 42D0494 FV1.11A5 DV8.3.18',
'HBA:QLE2562 FW:v5.03.02 DVR:v8.03.01.02.32.1-k9',
'HBA:Emulex LPe12002-M8 FV2.01A10 DV11.0.0.13. HN:(none) OS:Linux',
'HBA:Emulex LPe16002B-M6 FV10.4.255.23 DV11.0.0.13.',
'HBA:Emulex LPe31002-M6 FV11.2.156.27 DV11.0.0.13',
'HBA:QLE2692 FW:v8.03.04 DVR:v8.07.00.33.40.0-k',
'HBA:QLE2672 FW:v7.03.00 DVR:v8.07.00.33.40.0-k',
'HBA:HPAJ764A FW:v8.02.00 DVR:v8.07.00.33.40.0-k',
'HBA:SN1100Q FW:v8.05.61 DVR:v8.07.00.33.40.0-k',
'HBA:Emulex SN1100E2P FV10.2.340.19 DV11.0.0.13',
'HBA:Emulex LPe1250-F8 FV2.01A13 DV11.2.0.5',
'HBA:Emulex LPe12002-M8 FV2.01A10 DV11.2.0.5.',
'HBA:Emulex LPe16002B-M6 FV10.4.255.23 DV11.2.0.5.',
'HBA:Emulex LPe31002-M6 FV11.2.156.27 DV11.2.0.5',
'HBA:QLE2562 FW:v8.07.00 DVR:v8.07.00.38.40.0-k',
'HBA:QLE2692 FW:v8.03.04 DVR:v8.07.00.38.40.0-k',
'HBA:QLE2672 FW:v7.03.00 DVR:v8.07.00.38.40.0-k',
'HBA:HPAJ764A FW:v8.07.00 DVR:v8.07.00.38.40.0-k',
'HBA:SN1100Q FW:v8.05.61 DVR:v8.07.00.38.40.0-k',
'HBA:Emulex AJ763A/AH403A FV1.00A12 DV11.2.0.5',
'HBA:Emulex SN1100E2P FV10.2.340.19 DV11.2.0.5',
'HBA:QLE2560 FW:v5.06.05 DVR:v934.5.4.0-1vmw',
'HBA:QLE2670 FW:v8.00.00 DVR:v934.5.4.0-1vmw',
'HBA:QLE2560 FW:v5.06.05 DVR:v934.5.4.0-1vmw',
'HBA:QLE2670 FW:v8.00.00 DVR:v934.5.4.0-1vmw',
'HBA:Emulex LPe16000B-M6 FV11.2.156.27 DV8.2.3.1-127vmw',
'HBA:QLE2560 FW:v5.09.00 DVR:v1.0.12.0',
'HBA:QLE2670 FW:v8.00.00 DVR:v1.0.12.0',
'HBA:Emulex LPe12000-M8 FV2.02a0 DV10.0.100.1',
'HBA:Emulex LPe16000B-M6 FV11.2.156.27 DV10.0.100.1',
'HBA:QLE2560 FW:v7.02.00 DVR:v2.0.12.0',
'HBA:QLE2570 FW:v8.01.02 DVR:v2.0.12.0',
'HBA:Emulex LPe12000-M8 FV2.02A3 DV10.2.309.8',
'HBA:Emulex LPe16000B-M6 FV10.2.252.16 DV10.2.309.8',
'HBA:QLE2560 FW:v5.06.05 DVR:v902.k1.1-9vmw',
'HBA:QLE2570 FW:v8.01.02 DVR:v2.1.30.0',
'HBA:Emulex LPe12000-M8 FV2.02A3 DV11.1.0.6 HN:localhost OS:VMware ESXi 6.5.0',
'HBA:Emulex LPe16000B-M6 FV10.2.252.16 DV11.1.0.6 HN:localhost OS:VMware ESXi 6.5.0',
'HBA:QLE2560 FW:v8.02.00 DVR:v9.1.17.21',
'HBA:QLE2570 FW:v7.01.00 DVR:v9.1.17.21',
'HBA:Emulex LPe12000 FV2.01A11 DV10.0.720.0 WIN-6E87PLUAJ5M',
'HBA:QLE2560 FW:v8.05.00 DVR:v9.2.6.22',
'HBA:QLE2570 FW:v7.01.00 DVR:v9.2.6.22',
'HBA:Emulex LPe12000 FV2.01A11 DV11.2.139.0 HN:WIN-8NVH3NFPICQ OS:Windows2012',
'HBA:Emulex LPe16000B-M6 FV10.4.255.23 DV11.2.139.0',
'HBA:QLE2560 FW:v5.09.00 DVR:v9.1.11.3',
'HBA:QLE2570 FW:v7.01.00 DVR:v9.1.11.3',
'HBA:Emulex LPe12000    FV2.01A11 DV2.74.214.004 WIN-65TU9932AA2',
'HBA:Emulex LPe16000B-M6 FV10.4.255.23 DV2.74.214.004 WIN-65TU9932AA2',
'HBA:QLE2560 FW:v8.01.02 DVR:v9.1.15.1',
'HBA:QLE2570 FW:v7.01.00 DVR:v9.1.15.1',
'HBA:Emulex LPe12000 FV2.01A11 DV11.0.247.8000 HN:WIN-I52RHUC6JF2 OS:Windows2016',
'HBA:Emulex LPe16000B-M6 FV10.4.255.23 DV11.0.247.8000 HN:WIN-I52RHUC6JF2 OS:Windows2016',
'HBA:QLE2560 FW:v8.00.00 DVR:v8.07.00.18-k',
'HBA:QLE2570 FW:v8.00.00 DVR:v8.07.00.18-k',
'HBA:QLE2560 FW:v5.06.03 DVR:v8.03.07.07-k',
'HBA:Emulex LPe16000B-M6 FV11.2.156.27 DV8.3.5.48.2p',
'HBA:QLE2560 FW:v8.00.00 DVR:v8.07.00.18-k',
'HBA:QLE2570 FW:v8.01.02 DVR:v8.07.00.18-k',
'HBA:Emulex LPe12000-M8 FV2.01A10 DV10.4.8000.0.',
'HBA:Emulex LPe16000B-M6 FV11.2.156.27 DV10.4.8000.0.',
'HBA:QLE2560 FW:v7.03.00 DVR:v8.07.00.08.12.0-k',
'HBA:QLE2570 FW:v6.06.03 DVR:v8.07.00.08.12.0-k',
'HBA:Emulex LPe16000B-M6 FV11.2.156.27 DV10.2.8040.1',
'HBA:Emulex LPe12000-M8 FV2.01A10 DV11.4.0.1. HN:linux-n4sr. OS:Linux',
'HBA:Emulex LPe16000B-M6 FV11.2.156.27 DV11.4.0.1. HN:linux-n4sr. OS:Linux',
'HBA:QLE2560 FW:v8.07.00 DVR:v8.07.00.38.40.0-k',
'HBA:QLE2670 FW:v8.01.02 DVR:v8.07.00.38.40.0-k',
'HBA:Emulex LPe12000-M8 FV2.01A10 DV11.2.0.5. HN:localhost.localdomain OS:Linux',
'HBA:Emulex LPe16000B-M6 FV11.2.156.27 DV11.2.0.5. HN:localhost.localdomain OS:Linux',
'HBA:QLE2560 FW:v7.00.01 DVR:v8.05.00.03.06.5-k2',
'HBA:QLE2670 FW:v7.03.00 DVR:v8.05.00.03.06.5-k2',
'HBA:Emulex LPe12000-M8 FV2.02A1 DV8.3.7.21.4p',
'HBA:Emulex LPe16000B-M6 FV11.2.156.27 DV8.3.7.21.4p',
'HBA:QLE2560 FW:v7.03.00 DVR:v8.07.00.26.06.8-k',
'HBA:QLE2670 FW:v7.03.00 DVR:v8.07.00.26.06.8-k',
'HBA:Emulex LPe12000-M8 FV2.02A1 DV11.0.0.4 HN:(none) OS:Linux',
'HBA:Emulex LPe16000B-M6 FV11.2.156.27 DV11.0.0.4 HN:(none) OS:Linux',
'HBA:QLE2560 FW:v7.01.00 DVR:v8.06.00.08.07.0-k2',
'HBA:Emulex LPe12000-M8 FV2.02A1 DV8.3.7.34.3p',
'HBA:Emulex LPe16000B-M6 FV11.2.156.27 DV8.3.7.34.3p',
'HBA:QLE2560 FW:v8.01.02 DVR:v8.07.00.18.07.2-k',
'HBA:QLE2570 FW:v7.03.00 DVR:v8.07.00.18.07.2-k',
'HBA:Emulex LPe12000-M8 FV2.02A1 DV10.7.0.1 HN:localhost OS:Linux',
'HBA:Emulex LPe16000B-M6 FV11.2.156.27 DV10.7.0.1 HN:localhost OS:Linux',
'HBA:QLE2560 FW:v5.08.00 DVR:v8.06.00.10.11.1-k',
'HBA:QLE2570 FW:v7.03.00 DVR:v8.06.00.10.11.1-k',
'HBA:Emulex LPe12000-M8 FV2.02A0 DV10.6.133.8 HN:(none) OS:Linux',
'HBA:Emulex LPe16000B-M6 FV11.2.156.27 DV10.6.133.8 HN:(none) OS:Linux',
'HBA:QLE2560 FW:v5.08.00 DVR:v8.06.00.10.11.1-k',
'HBA:QLE2570 FW:v7.03.00 DVR:v8.06.00.10.11.1-k',
'HBA:Emulex LPe12000-M8 FV2.02A0 DV10.6.133.8 HN:(none) OS:Linux',
'HBA:Emulex LPe16000B-M6 FV11.2.156.27 DV10.6.133.8 HN:(none) OS:Linux',
'HBA:QLE2560 FW:v5.08.00 DVR:v8.06.00.10.11.1-k',
'HBA:QLE2570 FW:v7.03.00 DVR:v8.06.00.10.11.1-k',
'HBA:Emulex LPe12000-M8 FV2.02A0 DV8.3.7.18 HN:(none) OS:Linux',
'HBA:Emulex LPe16000B-M6 FV11.2.156.27 DV8.3.7.18 HN:(none) OS:Linux',
'HBA:QLE2560 FW:v8.02.00 DVR:v8.07.00.33.40.0-k',
'HBA:QLE2570 FW:v7.03.00 DVR:v8.07.00.33.40.0-k',
'HBA:Emulex LPe12000-M8 FV2.00A4 DV11.0.0.13. HN:(none) OS:Linux',
'HBA:Emulex LPe16000B-M6 FV11.2.156.27 DV11.0.0.13. HN:(none) OS:Linux',
'HBA:Emulex LPe16000B-M6 FV10.4.255.23 DV10.2.309.8',
'HBA:Emulex LPe12000    FV2.01A11 DV10.2.309.8',
'HBA:Emulex LPe16000B-M6 FV10.4.255.23 DV10.2.309.8',
'HBA:Emulex LPe16000B-M6 FV10.4.255.23 DV11.1.145.18',
'HBA:QLE2560 FW:v7.02.00 DVR:v2.0.12.0',
'HBA:QLE2560 FW:v7.03.00 DVR:v8.07.00.16.06.7-k',
'HBA:QLE2560 FW:v8.02.00 DVR:v2.1.50.0',
'HBA:QLE2560 FW:v8.03.00 DVR:v8.07.00.33.07.3-k1',
'HBA:QLE2562 FW:v5.06.05 DVR:v934.5.4.0-1vmw',
'HBA:QLE2672 FW:v8.00.00 DVR:v934.5.4.0-1vmw',
'HBA:QLE2562 FW:v5.06.05 DVR:v934.5.4.0-1vmw',
'HBA:QLE2672 FW:v8.00.00 DVR:v934.5.4.0-1vmw',
'HBA:Emulex LPe16002B-M6 FV11.2.156.27 DV8.2.3.1-127vmw',
'HBA:QLE2562 FW:v5.09.00 DVR:v1.0.12.0',
'HBA:QLE2672 FW:v8.00.00 DVR:v1.0.12.0',
'HBA:Emulex LPe12002-M8 FV2.02a0 DV10.0.100.1',
'HBA:Emulex 42D0494 FV2.01A12 DV10.0.100.1',
'HBA:Emulex LPe16002B-M6 FV11.2.156.27 DV10.0.100.1',
'HBA:QLE2562 FW:v7.02.00 DVR:v2.0.12.0',
'HBA:QLE2672 FW:v8.01.02 DVR:v2.0.12.0',
'HBA:Emulex LPe12002-M8 FV2.02A3 DV10.2.309.8',
'HBA:Emulex LPe16002B-M6 FV10.2.252.16 DV10.2.309.8',
'HBA:QLE2562 FW:v5.06.05 DVR:v902.k1.1-9vmw',
'HBA:QLE2672 FW:v8.01.02 DVR:v2.1.30.0',
'HBA:Emulex 42D0494 FV2.02A3 DV11.1.0.6 HN:localhost OS:VMware ESXi 6.5.0',
'HBA:Emulex LPe12002-M8 FV2.02A3 DV11.1.0.6 HN:localhost OS:VMware ESXi 6.5.0',
'HBA:Emulex 00E3495 FV10.2.252.16 DV11.1.0.6 HN:localhost OS:VMware ESXi 6.5.0',
'HBA:Emulex LPe16002B-M6 FV10.2.252.16 DV11.1.0.6 HN:localhost OS:VMware ESXi 6.5.0',
'HBA:QLE2562 FW:v8.02.00 DVR:v9.1.17.21',
'HBA:QLE2672 FW:v7.01.00 DVR:v9.1.17.21',
'HBA:Emulex LPe12002 FV2.01A11 DV10.0.720.0 WIN-6E87PLUAJ5M',
'HBA:QLE2562 FW:v8.05.00 DVR:v9.2.6.22',
'HBA:QLE2672 FW:v7.01.00 DVR:v9.2.6.22',
'HBA:Emulex LPe12002 FV2.01A11 DV11.2.139.0 HN:WIN-8NVH3NFPICQ OS:Windows2012',
'HBA:Emulex LPe16002B-M6 FV10.4.255.23 DV11.2.139.0',
'HBA:QLE2562 FW:v5.09.00 DVR:v9.1.11.3',
'HBA:QLE2672 FW:v7.01.00 DVR:v9.1.11.3',
'HBA:Emulex LPe12002    FV2.01A11 DV2.74.214.004 WIN-65TU9932AA2',
'HBA:Emulex LPe16002B-M6 FV10.4.255.23 DV2.74.214.004 WIN-65TU9932AA2',
'HBA:QLE2562 FW:v8.01.02 DVR:v9.1.15.1',
'HBA:QLE2672 FW:v7.01.00 DVR:v9.1.15.1',
'HBA:Emulex LPe12002 FV2.01A11 DV11.0.247.8000 HN:WIN-I52RHUC6JF2 OS:Windows2016',
'HBA:Emulex LPe16002B-M6 FV10.4.255.23 DV11.0.247.8000 HN:WIN-I52RHUC6JF2 OS:Windows2016',
'HBA:QLE2672 FW:v8.00.00 DVR:v8.07.00.18-k',
'HBA:QLE2672 FW:v8.00.00 DVR:v8.07.00.18-k',
'HBA:QLE2562 FW:v5.06.03 DVR:v8.03.07.07-k',
'HBA:Emulex 42D0494 FV1.11A5 DV8.3.5.48.2p',
'HBA:Emulex LPe16002B-M6 FV11.2.156.27 DV8.3.5.48.2p',
'HBA:QLE2562 FW:v8.00.00 DVR:v8.07.00.18-k',
'HBA:QLE2672 FW:v8.01.02 DVR:v8.07.00.18-k',
'HBA:Emulex LPe12002-M8 FV2.01A10 DV10.4.8000.0.',
'HBA:Emulex LPe16002B-M6 FV11.2.156.27 DV10.4.8000.0.',
'HBA:QLE2562 FW:v7.03.00 DVR:v8.07.00.08.12.0-k',
'HBA:QLE2672 FW:v6.06.03 DVR:v8.07.00.08.12.0-k',
'HBA:Emulex 42D0494 FV1.11A5 DV10.2.8040.1',
'HBA:Emulex LPe16002B-M6 FV11.2.156.27 DV10.2.8040.1',
'HBA:Emulex LPe12002-M8 FV2.01A10 DV11.4.0.1. HN:linux-n4sr. OS:Linux',
'HBA:Emulex LPe16002B-M6 FV11.2.156.27 DV11.4.0.1. HN:linux-n4sr. OS:Linux',
'HBA:QLE2562 FW:v8.07.00 DVR:v8.07.00.38.40.0-k',
'HBA:QLE2672 FW:v8.01.02 DVR:v8.07.00.38.40.0-k',
'HBA:Emulex LPe12002-M8 FV2.01A10 DV11.2.0.5. HN:localhost.localdomain OS:Linux',
'HBA:Emulex LPe16002B-M6 FV11.2.156.27 DV11.2.0.5. HN:localhost.localdomain OS:Linux',
'HBA:QLE2562 FW:v7.00.01 DVR:v8.05.00.03.06.5-k2',
'HBA:QLE2672 FW:v7.03.00 DVR:v8.05.00.03.06.5-k2',
'HBA:Emulex LPe12002-M8 FV2.02A1 DV8.3.7.21.4p',
'HBA:Emulex 42D0494 FV2.01A12 DV8.3.7.21.4p',
'HBA:Emulex LPe16002B-M6 FV11.2.156.27 DV8.3.7.21.4p',
'HBA:QLE2562 FW:v7.03.00 DVR:v8.07.00.26.06.8-k',
'HBA:QLE2672 FW:v7.03.00 DVR:v8.07.00.26.06.8-k',
'HBA:Emulex LPe12002-M8 FV2.02A1 DV11.0.0.4 HN:(none) OS:Linux',
'HBA:Emulex LPe16002B-M6 FV11.2.156.27 DV11.0.0.4 HN:(none) OS:Linux',
'HBA:QLE2562 FW:v7.01.00 DVR:v8.06.00.08.07.0-k2',
'HBA:Emulex LPe12002-M8 FV2.02A1 DV8.3.7.34.3p',
'HBA:Emulex 42D0494 FV2.01A12 DV8.3.7.34.3p',
'HBA:Emulex LPe16002B-M6 FV11.2.156.27 DV8.3.7.34.3p',
'HBA:QLE2562 FW:v8.01.02 DVR:v8.07.00.18.07.2-k',
'HBA:QLE2672 FW:v7.03.00 DVR:v8.07.00.18.07.2-k',
'HBA:Emulex LPe12002-M8 FV2.02A1 DV10.7.0.1 HN:localhost OS:Linux',
'HBA:Emulex LPe16002B-M6 FV11.2.156.27 DV10.7.0.1 HN:localhost OS:Linux',
'HBA:QLE2562 FW:v5.08.00 DVR:v8.06.00.10.11.1-k',
'HBA:QLE2672 FW:v7.03.00 DVR:v8.06.00.10.11.1-k',
'HBA:Emulex LPe12002-M8 FV2.02A0 DV10.6.133.8 HN:(none) OS:Linux',
'HBA:Emulex LPe16002B-M6 FV11.2.156.27 DV10.6.133.8 HN:(none) OS:Linux',
'HBA:QLE2562 FW:v5.08.00 DVR:v8.06.00.10.11.1-k',
'HBA:QLE2672 FW:v7.03.00 DVR:v8.06.00.10.11.1-k',
'HBA:Emulex LPe12002-M8 FV2.02A0 DV10.6.133.8 HN:(none) OS:Linux',
'HBA:Emulex LPe16002B-M6 FV11.2.156.27 DV10.6.133.8 HN:(none) OS:Linux',
'HBA:QLE2562 FW:v5.08.00 DVR:v8.06.00.10.11.1-k',
'HBA:QLE2672 FW:v7.03.00 DVR:v8.06.00.10.11.1-k',
'HBA:Emulex LPe12002-M8 FV2.02A0 DV8.3.7.18 HN:(none) OS:Linux',
'HBA:Emulex LPe16002B-M6 FV11.2.156.27 DV8.3.7.18 HN:(none) OS:Linux',
'HBA:QLE2562 FW:v8.02.00 DVR:v8.07.00.33.40.0-k',
'HBA:QLE2672 FW:v7.03.00 DVR:v8.07.00.33.40.0-k',
'HBA:Emulex LPe12002-M8 FV2.00A4 DV11.0.0.13. HN:(none) OS:Linux',
'HBA:Emulex LPe16002B-M6 FV11.2.156.27 DV11.0.0.13. HN:(none) OS:Linux',
'HBA:Emulex LPe16002B-M6 FV10.4.255.23 DV10.2.309.8',
'HBA:Emulex LPe12002    FV2.01A11 DV10.2.309.8',
'HBA:Emulex LPe16002B-M6 FV10.4.255.23 DV10.2.309.8',
'HBA:Emulex LPe16002B-M6 FV10.4.255.23 DV11.1.145.18',
'HBA:QLE2560 FW:v7.02.00 DVR:v2.0.12.0',
'HBA:QLE2560 FW:v7.03.00 DVR:v8.07.00.16.06.7-k',
'HBA:QLE2560 FW:v8.03.00 DVR:v8.07.00.33.07.3-k1',
'HBA:Emulex LPe16002B-M6 FV10.4.255.23 DV11.1.145.18',
'HBA:Emulex LPe12002-M8 FV2.01A10 DV10.2.8021.1',
'HBA:Emulex LPe12002    FV2.01A11 DV11.2.266.0',
'HBA:QLE2562 FW:v5.08.00  DVR:v8.04.00.13.11.3-k',
'HBA:QLE2672 FW:v7.01.00  DVR:v8.04.00.13.11.3-k',
'HBA:Emulex LPe12002-M8 FV2.01A11 DV8.3.7.10.6p',
'HBA:Emulex LPe16002B-M6 FV10.4.255.23 DV8.3.7.10.6p',
'HBA:Emulex 42D0494 FV2.01A12  DV8.2.2.1-18vmw',
'HBA:Emulex LPe16000B-M6 FV10.4.255.23 DV11.1.145.18',
'HBA:Emulex LPe12000-M8 FV2.01A10 DV10.2.8021.1',
'HBA:Emulex LPe12000    FV2.01A11 DV11.2.266.0',
'HBA:QLE2560 FW:v5.08.00 DVR:v8.04.00.13.11.3-k',
'HBA:QLE2670 FW:v7.01.00 DVR:v8.04.00.13.11.3-k',
'HBA:Emulex LPe12000-M8 FV2.01A11 DV8.3.7.10.6p',
'HBA:Emulex LPe16000B-M6 FV10.4.255.23 DV8.3.7.10.6p']