# -*- coding: UTF-8 -*-
from frame.cli import cliUtil
from frame.common import common
from frame.context import contextUtil

def execute(context):
    '''
                      硬盘健康度检查：
        Health Mark在0-60之间表示异常，其它情况均属于正常状态。
    '''
    lang = contextUtil.getLang(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    cli = contextUtil.getSSH(context)
    flag = True
    cliRet = ""
    errMsg = ""
    
    try:
        cmd = "show disk health"
        logger.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, False, lang)

        # 命令不存在场景时，返回不涉及
        if not cliUtil.hasCliExecPrivilege(checkRet[1]):
            return common.getUpgEvaluationRs(cliUtil.RESULT_NOSUPPORT, checkRet[1], "")

        if checkRet[0] != True: 
            logger.logSysAbnormal()
            return common.getUpgEvaluationRs(checkRet[0], checkRet[1], checkRet[2])
        
        cliRet = checkRet[1]
        cliRetLinesList = cliUtil.getVerticalCliRet(cliRet)
        if len(cliRetLinesList) == 0:
            return common.getUpgEvaluationRs(True, cliRet, errMsg)
        
        for retDict in cliRetLinesList:
            diskId = retDict["Disk ID"]
            healthMark = retDict["Health Mark"]
                
            if healthMark.isdigit():
                healthMarkDigit = int(healthMark)
                if healthMarkDigit >= 0 and healthMarkDigit <= 60:
                    flag = False
                    errMsg += common.getMsg(lang, "disk.health.mark.abnormal", (diskId, healthMark))
                    logger.logNoPass("The health mark of Disk [%s] is abnormal (Health Mark:%s)" % (diskId, healthMark))
    
        if flag:
            logger.logPass()
            
        return common.getUpgEvaluationRs(flag, cliRet, errMsg)
    
    except Exception, exception:     
        logger.logException(exception)
        return common.getUpgEvaluationRs(False, cliRet, common.getMsg(lang, "query.result.abnormal"))
