# -*- coding: UTF-8 -*-
from frame.cli import cliUtil
from frame.common import common
from frame.context import contextUtil

def execute(context):
    '''
            独立机头最后两个槽位是否为SAS接口卡：
            型号：独立机头设备5600 V35800 V36800 V36900 V3
            版本： V3R1:<=V3R1C10SPC200
        V3R2:<=V3R2C10
    '''
    
    LANG = contextUtil.getLang(context)
    LOGGER = common.getLogger(contextUtil.getLogger(context), __file__)
    cli = contextUtil.getSSH(context)
    flag = True
    cliRet = ""
    cliRetToShow = ""
    errMsg = ""
    
    verRangeDict = {"V300R001":"V300R001C10SPC200",
                    "V300R002":"V300R002C10"}
    
    devTypePortDict = {"5600 V3":["A6","A7","B6","B7"],
                       "5600F V3":["A6","A7","B6","B7"],
                       "5800 V3":["A6","A7","B6","B7"],
                       "5800F V3":["A6","A7","B6","B7"],
                       "6800 V3":["R4","R5","L4","L5"],
                       "6800F V3":["R4","R5","L4","L5"],
                       "6900 V3":["R4","R5","L4","L5"]}
    
    try:
        #检查是否在版本范围内
        getDevVersionRet = common.getDevVersion(cli, LANG, LOGGER)
        if not getDevVersionRet[0]:
            if LANG == "zh":
                errMsg = u"无法获取产品版本信息。"
            else:
                errMsg = "Cannot get information about product version."
            return common.getUpgEvaluationRs(getDevVersionRet[0], getDevVersionRet[2], errMsg)
        
        cliRetToShow += getDevVersionRet[2]
        devVersion = getDevVersionRet[1]
        versionToVR = devVersion[0:8]
        if devVersion >= verRangeDict.get(versionToVR):
            return common.getUpgEvaluationRs(cliUtil.RESULT_NOSUPPORT, cliRetToShow, errMsg)
        
        #检查是否在型号范围内
        deviceType = contextUtil.getDevType(context)
        if deviceType not in devTypePortDict:
            return common.getUpgEvaluationRs(cliUtil.RESULT_NOSUPPORT, cliRetToShow, errMsg)
        
        #根据端口号检查
        portToCheckList = devTypePortDict.get(deviceType)
        cmd = "show interface_module"
        LOGGER.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        cliRetToShow += checkRet[1]
        if checkRet[0] != True:
            LOGGER.logSysAbnormal()
            return common.getUpgEvaluationRs(checkRet[0], cliRetToShow, checkRet[2])
        
        cliRet = checkRet[1]
        
        cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
        if len(cliRetLinesList) == 0:
            errMsg = common.getMsg(LANG, "cannot.get.interface")
            LOGGER.logNoPass("Cannot get information about interface")
            return common.getUpgEvaluationRs(False, cliRetToShow, errMsg)
        
        for item in cliRetLinesList:
            interfaceID = item.get("ID")
            for port in portToCheckList:
                if port in interfaceID:
                    if " SAS " in item.get("Model"):
                        flag = False
                        errMsg += common.getMsg(LANG, "lasttwo.has.SASCard", interfaceID)
                        LOGGER.logNoPass("Interface ID:[%s] has a SAS Card." %interfaceID)
                    break
                
        if flag:
            LOGGER.logPass()
            
        return common.getUpgEvaluationRs(flag, cliRetToShow, errMsg)
    
    except Exception, exception:
        LOGGER.logException(exception)
        return common.getUpgEvaluationRs(False, cliRetToShow, common.getMsg(LANG, "query.result.abnormal"))
