# -*- coding: UTF-8 -*-
from frame.common import common
from frame.cli import cliUtil
from frame.context import contextUtil

def execute(context):
    '''
    检查标准
    1、待升级到的目标版本为V200R002C30或V200R002C30SPC100或V200R002C30SPC200，并且步骤2中系统版本为V200R002C00或V200R002C00SPC200或V200R002C00SPC400或V200R002C10或V200R002C20或V200R002C20SPC200，并且产品型号为S2600T则需要继续执行步骤3，否则检查项通过。
    2、步骤3中Model字段存在2x10GE Optical Interface Module接口模块，检查不通过；否则，检查通过。
    '''
    #回显，语言,日志,错误信息变量
    allCliRet = ''
    errMsg = ''
    lang = contextUtil.getLang(context)
    log = common.getLogger(contextUtil.getLogger(context), __file__)
    cli = contextUtil.getSSH(context)   
   
    #定义需检查设备型号和版本号相关变量
    v_devType = "S2600T"
    v_curentVersion = ["V200R002C00","V200R002C00SPC200","V200R002C00SPC400","V200R002C10","V200R002C20","V200R002C20SPC200"]
    v_targetVersion = ["V200R002C30","V200R002C30SPC100","V200R002C30SPC200"]
    
    #从上下文取得设备型号和版本号  
    devType = contextUtil.getDevType(context)    
    curentVersion = common.formatVersion(contextUtil.getCurVersion(context))
    targetVersion = common.formatVersion(contextUtil.getTargetVersion(context))    
    
    try:       
        #执行show system general命令
        allCliRet = cli.execCmd("show system general")
        
        #设备型号检查
        if not(devType == v_devType):
            log.logPass()
            return common.getUpgEvaluationRs(cliUtil.RESULT_NOSUPPORT, allCliRet, errMsg)
        
        #当前版本和目标版本检查
        if not (curentVersion in v_curentVersion) or not (targetVersion in v_targetVersion) :
            log.logPass()
            return common.getUpgEvaluationRs(cliUtil.RESULT_NOSUPPORT, allCliRet, errMsg)
        
        #执行show interface_module命令
        cmd = 'show interface_module'
        log.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
        cliRetToShow = checkRet[1]
        allCliRet += cliRetToShow
        if checkRet[0] != True:
            log.logSysAbnormal()
            return common.getUpgEvaluationRs(checkRet[0], allCliRet, checkRet[2])      

        #模块检查：不存在2x10GE Optical Interface Module接口，检查通过
        cliRet = checkRet[1]        
        cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
        if len(cliRetLinesList) == 0:
            errMsg = common.getMsg(lang, "cannot.get.interface")
            log.logPass()
            return common.getUpgEvaluationRs(True, allCliRet, errMsg)
        
        #模块检查：存在2x10GE Optical Interface Module接口，检查不通过
        flag = True
        for item in cliRetLinesList:
            interfaceID = item.get("ID")
            interfaceModel = item.get("Model")
            if "2x10GE Optical Interface" in interfaceModel:
                flag = False
                errMsg += common.getMsg(lang, "check.2x10GEOpticalInterface.exist", interfaceID)
                log.logNoPass("Slot [ID:%s]: 2 x 10GE optical modules exist. Please handle the issue based on the suggestions." %interfaceID)             
        return common.getUpgEvaluationRs(flag, allCliRet, errMsg) 
    
    except Exception, exception: 
        log.logException(exception)
        return common.getUpgEvaluationRs(False, allCliRet, common.getMsg(lang, "query.result.abnormal"))

