# -*- coding: UTF-8 -*-
from frame.common.regex import Regex
from frame.common import common
from frame.cli import cliUtil
from frame.context import contextUtil

#当前系统是否存在IPV6配置事件
G_ExistIPv6ConfEvent = False

#所有查询事件的回文、命令错误信息
G_AllEventCliRet = ""
G_EventCheckCmdErr = ""


def ifCreateIpv6Conf(cliRet4EventSeq):
    
    eventSeqDictList = cliUtil.getVerticalCliRet(cliRet4EventSeq)
    eventSeqDetal = eventSeqDictList[0].get('Detail')
    #iSNS事件中是否存在IPv6地址信息，检查不通过
    if eventSeqDetal.count(':') >= 2:
        return True
    return False

def createEventBaseDict(cliRet4Event):

    eventBaseDict = {}
    eventDictList = cliUtil.getHorizontalCliRet(cliRet4Event)
    for eventDict in eventDictList:
        sequenceId = eventDict.get('Sequence', '')
        if sequenceId and sequenceId.isdigit():#暂时无数据，可以保留存储其他关键数据
            eventBaseDict[int(sequenceId)] = ""
    return eventBaseDict

def getRebootEventInfo(ssh, lang):
    
    global G_ExistIPv6ConfEvent, G_AllEventCliRet, G_EventCheckCmdErrglobal

    rebootEventDict = {}
    
    #所有版本都是查询重启操作日志
    cmd = 'show event |filterRow column=ID predict=equal_to value=0x200F00C90043'
    tmpFlag, cliRet, errMsg = cliUtil.excuteCmdInCliMode(ssh, cmd, True, lang)
    G_AllEventCliRet += cliRet
    if tmpFlag != True:
        G_EventCheckCmdErr = errMsg
        return (False, rebootEventDict)

    #获取重启事件信息
    rebootEventDict = createEventBaseDict(cliRet)
    return (True, rebootEventDict)

def getConfigEventInfo(ssh, lang):
    
    global G_ExistIPv6ConfEvent, G_AllEventCliRet, G_EventCheckCmdErr

    createEventDict = {}
    cmd = 'show event |filterRow column=ID predict=equal_to value=0x200F01020014'
    tmpFlag, cliRet, errMsg = cliUtil.excuteCmdInCliMode(ssh, cmd, True, lang)
    G_AllEventCliRet += cliRet
    if tmpFlag != True:
        G_EventCheckCmdErr = errMsg
        return (False, createEventDict)
    
    #获取配置事件信息
    createEventDictTmp = createEventBaseDict(cliRet)
    for sequenceId in createEventDictTmp:
        cmd = 'show event sequence=%s' % str(sequenceId)
        tmpFlag, cliRet4EventSeq, errMsg = cliUtil.excuteCmdInCliMode(ssh, cmd, True, lang)
        G_AllEventCliRet += cliRet4EventSeq
        if tmpFlag != True:
            G_EventCheckCmdErr = errMsg
            return (False, createEventDict)

        #设置事件中的属性:IPV4还是IPV6
        if ifCreateIpv6Conf(cliRet4EventSeq):
            createEventDict[sequenceId] = "IPV6"
            G_ExistIPv6ConfEvent = True
        else:
            createEventDict[sequenceId] = "IPV4"

    return (True, createEventDict)

def getDeleteEventInfo(ssh, lang):
    
    global G_ExistIPv6ConfEvent, G_AllEventCliRet, G_EventCheckCmdErr

    deleteEventDict = {}
    cmd = 'show event |filterRow column=ID predict=equal_to value=0x200F01020017'
    tmpFlag, cliRet, errMsg = cliUtil.excuteCmdInCliMode(ssh, cmd, True, lang)
    G_AllEventCliRet += cliRet
    if tmpFlag != True:
        G_EventCheckCmdErr = errMsg
        return (False, deleteEventDict)
    
    #获取删除配置事件信息
    deleteEventDict = createEventBaseDict(cliRet)
    return (True, deleteEventDict)


def checkSysRiskByEvent(ssh, lang):

    global G_ExistIPv6ConfEvent, G_AllEventCliRet, G_EventCheckCmdErr
    
    #获取重启事件信息
    tmpFlag, rebootEventInfo = getRebootEventInfo(ssh, lang)
    if not tmpFlag:
        #命令执行失败
        return False
    #获取配置事件信息
    tmpFlag, configEventInfo = getConfigEventInfo(ssh, lang)
    if not tmpFlag:
        #命令执行失败
        return False
    #获取删除配置事件信息
    tmpFlag, deleteEventInfo = getDeleteEventInfo(ssh, lang)
    if not tmpFlag:
        #命令执行失败
        return False
    
    #检查1：无设置IPV6的事件，则检查通过
    if not G_ExistIPv6ConfEvent:
        return True    
    #检查2：有设置IPV6的事件:无重启事件，检查不通过
    if not rebootEventInfo:
        return False
    #检查3：有重启事件，并且有配置IPV6的事件:
    rebootSeqList = rebootEventInfo.keys()
    rebootSeqList.sort()#序列号从小到大排列
    lastRebootSeq = rebootSeqList[-1]

    #事件序列号唯一，合并成一个序列号列表（最后一次重启、所有配置、所有删除事件列表）
    configSeqList = configEventInfo.keys()
    deleteSeqList = deleteEventInfo.keys()
    allSeqList = [lastRebootSeq] + configSeqList + deleteSeqList
    allSeqList.sort()#序列号从小到大排列

    lastRebootSeqIndex = allSeqList.index(lastRebootSeq)

    #检查4：最后一次重启后是否有配置IPV6事件
    seqListAfterLastReboot = allSeqList[lastRebootSeqIndex + 1:]
    for seqId in seqListAfterLastReboot:
        if seqId in configSeqList:
            #最后一次重启后仍然有IPV6事件，检查不通过
            if configEventInfo[seqId] == "IPV6":
                return False   
    #所有的配置(必然包含IPV6配置)与删除动作事件都在重启之后，检查不通过
    if lastRebootSeqIndex == 0:
        return False

    #检查5：获取重启前最后一个非重启的动作类型    
    lastEventBeforeRebootSeq = allSeqList[lastRebootSeqIndex - 1]
    if lastEventBeforeRebootSeq in deleteSeqList:
        #重启前最后一个动作为删除，则重启前数据已被清除，检查通过
        return True
    else:#重启前最后一个动作为配置
        if configEventInfo[lastEventBeforeRebootSeq] == "IPV6":
            #重启前的最后一个动作为配置IPV6，检查不通过
            return False
        else:
            return True

def execute(context):
    '''
    @summary: the entrance of main method, this check item is used to check iSNS IPv6
    @param context: the dictionary of data which provided by tool framework
    @return: (pass status, CLI information, error message) as (integer, string, string)
    '''
    global G_AllEventCliRet
    
    allCliRet = ''
    errMsg = ''
    lang = contextUtil.getLang(context)
    log = common.getLogger(contextUtil.getLogger(context), __file__)
    
    #检查当前版本是否涉及当前检查项
    if not common.needCheckItem(contextUtil.getCurVersion(context), __file__):
        log.logInfo('The current version is not involved the check item')
        return common.getUpgEvaluationRsNoInvolved()
    try:
        #步骤1：查看是否有iSCSI接口
        ssh = contextUtil.getSSH(context)
        cmd = 'show interface_module'
        tmpFlag, cliRet4IntfModule, errMsg = cliUtil.excuteCmdInCliMode(ssh, cmd, True, lang)
        allCliRet += cliRet4IntfModule
        if tmpFlag != True:
            log.logSysAbnormal()
            return common.getUpgEvaluationRs(False, allCliRet, errMsg)
        
        #不存在iSCSI接口，检查通过
        pattern = '4x10GE Electrical Interface Module'
        if not Regex.find(pattern, cliRet4IntfModule):
            return common.getUpgEvaluationRs(True, allCliRet, errMsg)
        
        #步骤2：查看是否有IPv6的地址信息
        cmd = 'show isns server_ip'
        tmpFlag, cliRet4isns, errMsg = cliUtil.excuteCmdInCliMode(ssh, cmd, True, lang)
        allCliRet += cliRet4isns
        if tmpFlag != True:
            log.logSysAbnormal()
            return common.getUpgEvaluationRs(False, allCliRet, errMsg)
        
        #存在IPv6的地址，检查不通过
        if cliRet4isns.count(':') >= 4:
            errMsg = common.getMsg(lang, "check.ipv6.exist.notpass")#u'iSNS服务配置了IPv6地址，不支持升级。'
            return common.getUpgEvaluationRs(False, allCliRet, errMsg)
        
        #步骤3：通过查看事件判断是否存在风险
        global G_AllEventCliRet, G_EventCheckCmdErr
        tmpFlag = checkSysRiskByEvent(ssh, lang)
        allCliRet += G_AllEventCliRet
        if not tmpFlag:
            if G_EventCheckCmdErr:#命令执行失败
                errMsg = G_EventCheckCmdErr
            else:
                errMsg = common.getMsg(lang, "check.ipv6.exist.notpass")#u'iSNS服务配置了IPv6地址，不支持升级。'
            return common.getUpgEvaluationRs(False, allCliRet, errMsg)
        #检查通过
        return common.getUpgEvaluationRs(True, allCliRet, errMsg)
    except Exception, exception: 
        log.logException(exception)
        return common.getUpgEvaluationRs(False, allCliRet, common.getMsg(lang, "query.result.abnormal"))

