# -*- coding: UTF-8 -*-
from frame.cli import cliUtil
from frame.common import common
from frame.context import contextUtil
from java.lang import Exception as JException

HAS_NO_MIRROR_LUN = "Has_No_Mirror_Lun"

def execute(context):
    '''
    @summary: 检查项名称：LUN的镜像属性检查
    1.DoradoV3R1C21版本：
    步骤1 以admin用户登录；
    步骤2 执行show controller general命令，记录所有控制器ID(如0A，0B，...)。
    步骤3 执行change user_mode current_mode user_mode=developer进入developer视图；
    步骤4 执行show lun_cache no_mirror_lun controller=XX(XX代表控制器ID)，查看每个控制器的Has_No_Mirror_Lun的结果。

     步骤4中，只要有一个控制器回显中Has_No_Mirror_Lun的结果为“Yes”，检查不通过。


    '''
    
    cliRet = ""
    try:

        lang = contextUtil.getLang(context)
        logger = common.getLogger(contextUtil.getLogger(context), __file__)
        cli = contextUtil.getSSH(context)
        cliRet = ""
        allCliRet = ""
        cmdLunche = "show lun_cache no_mirror_lun controller=%s"
        cmd = "show lun_cache no_mirror_lun"
        controllerList = []
        flag = ""
        errMsg = ""
        isHasMirror = True


        #getControllerIdList内部执行show controller general|filterColumn include columnList=Controller获取控制器ID列表
        flag, controllerList, errMsg = cliUtil.getControllerIdList(cli, lang)
        logger.logInfo(controllerList)
        if flag != True:
            logger.logInfo("get Controller ID error")
            common.getUpgEvaluationRs(cliUtil.RESULT_NOCHECK, cliRet, errMsg)

        #遍历控制器ID，使每个控制器都去执行命令，查询回显是否正常
        #excuteCmdInDeveloperMode进入developer模式执行命令
        for controller in controllerList :
            flag, cliRet,errMsg = cliUtil.excuteCmdInDeveloperMode(cli, (cmdLunche % controller), True, lang, preExec=False)
            allCliRet += cliRet
            allCliRet += "\n"
            #异常场景
            if flag != True:
                return common.getUpgEvaluationRs(cliUtil.RESULT_NOCHECK, allCliRet, errMsg)
            cliRetController2List = cliUtil.getVerticalCliRet(cliRet)
            #异常场景。没有has_mirror字段
            if HAS_NO_MIRROR_LUN not in cliRet :
                logger.logInfo("execute cmd error,not have Has_No_Mirror_Lun")
                return common.getUpgEvaluationRs(cliUtil.RESULT_NOCHECK, allCliRet, common.getMsg(lang, "query.result.abnormal"))

            check = cliRetController2List[0].get(HAS_NO_MIRROR_LUN)
            #如果回显出现Yes则检查不通过
            if check.lower() == "yes":
                logger.logInfo("has some controller lun mirror error")
                logger.logInfo(allCliRet)
                isHasMirror = False


        return common.getUpgEvaluationRs(isHasMirror, allCliRet, "")



    except (Exception, JException), exception:
        logger.logException(exception)
        return common.getUpgEvaluationRs(cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(lang, "query.result.abnormal"))





    
