# -*- coding: UTF-8 -*-
from frame.analyze.toolAnalyzer import executeAnalyzer
from frame.common import common
from frame.context import contextUtil
from frame.cli import cliUtil
from frameone.util import contextUtil
from frame.base import baseUtil


def execute(context):
    '''
    @summary: 日志分区状态检查，检查项id“config_service_logzone_C30”
    '''
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    devVersion = contextUtil.getCurVersion(context)
    isDorado = contextUtil.isDoradoDev(context)
    devType = contextUtil.getDevType(context)
    logger.logInfo("[config_service_logzone_C30]current devVersion:%s, isDorado:%s" %(devVersion, isDorado))
    if isDorado:
        if devVersion < "V300R001C30SPC100":
            return common.getUpgEvaluationRs(cliUtil.RESULT_NOSUPPORT, "", "")
    elif not baseUtil.isDoradoNasDev(devType):
        if "V3" in devVersion and devVersion < "V300R006C50":
            return common.getUpgEvaluationRs(cliUtil.RESULT_NOSUPPORT, "", "")
        if "V5" in devVersion and devVersion < "V500R007C30":
            return common.getUpgEvaluationRs(cliUtil.RESULT_NOSUPPORT, "", "")

    queryCheckItem = "config_service_logzone_C30"
    checkRet = executeAnalyzer(context, queryCheckItem)
    return common.getUpgEvaluationRs(checkRet[0], checkRet[1], checkRet[2])
