# -*- coding: UTF-8 -*-
from frame.cli import cliUtil
from frame.common import common
from frame.context import contextUtil


def execute(context):
    
    '''
    @summary：检查独立机头设备保险框环路组网，要求正正接
    ''' 
    lang = contextUtil.getLang(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    cliRet = ""
    
    try:
        cli = contextUtil.getSSH(context)
        return checkConfCableAlarm(cli,logger,lang)
    
    except Exception, exception:
        logger.logException(exception)
        return common.getUpgEvaluationRs(False, cliRet, common.getMsg(lang, "query.result.abnormal"))

def checkConfCableAlarm(cli,logger,lang):
    '''
    @summary: V3R3C10SPC100及以后的版本查询告警：0xF00CE0033
    '''    
    alarmId = "0xF00CE0033"
    cmd = "show alarm |filterRow column=ID predict=equal_to value=0xF00CE0033"
    (flag, cliRet, errMsg) = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
    if flag != True:
        return common.getUpgEvaluationRs(flag, cliRet, errMsg)
    
    infoList = cliUtil.getHorizontalCliRet(cliRet)
    if len(infoList) > 0:
        errMsg = common.getMsg(lang, "conf.enclosure.cable.alarm.error", alarmId)
        return common.getUpgEvaluationRs(False, cliRet, errMsg)
    return common.getUpgEvaluationRs(True, cliRet, '')
    
