# -*- coding: UTF-8 -*-
from frame.cli import cliUtil
from frame.common import common
from frame.context import contextUtil
from frame.tlv import tlvUtil
from frame.tlv import tlvData

def execute(context):
    '''
    @summary: 外部LUN链路检查
    '''
    lang = contextUtil.getLang(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    cliRet = ""
    
    try:
        flag = True
        errMsg = ""
        tlv = contextUtil.getTlvObj(context)
        checkItem = "CHECK_SERVICE_EXTLUN_LINKSTATUS"
        logger.logExecCmd(checkItem)
        #根据检查项获取配置字典值
        itemDict = tlvData.UPD_CHECK_RESULT[checkItem]
        recs = tlvUtil.getUpgradeRecords(tlv, checkItem)
        logger.logInfo("records=%s" % unicode(recs))
        
        #获取cli回显
        cli = contextUtil.getSSH(context)
        cmd = "show remote_lun single_link"
        checkRet = cliUtil.excuteCmdInDeveloperMode(cli, cmd, True, lang)
        cliRet = checkRet[1]
        
        for record in recs:
            result = tlvUtil.getRecordValue(record, tlvData.CMO_UPD_EXECUTE_DEFINE["RESULT"])
            #根据模块返回值获取对应的字典值,如果失败返回None
            itemVal = itemDict.get(result, None)
            if itemVal is None:
                errMsg += common.getMsg(lang, "query.result.abnormal")
                flag = False
                continue
            status = itemVal.get("status", None)
            if status is True:
                continue
            flag = False
            errMsg += common.getMsg(lang, itemVal["msg"])
            
        return common.getUpgEvaluationRs(flag, cliRet, errMsg)
    except Exception, exception:
        logger.logException(exception)
        return common.getUpgEvaluationRs(False, cliRet, common.getMsg(lang, "query.result.abnormal"))
    