# -*- coding: UTF-8 -*-
from frame.cli import cliUtil
from frame.common import common
from frame.context import contextUtil
from frame.tlv import tlvUtil
from frame.tlv import tlvData

def execute(context):
    '''
    @summary: 系统告警检查
    '''
    
    lang = contextUtil.getLang(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    cliRet = ""
    
    try:
        flag = True
        errMsg = ""
        tlv = contextUtil.getTlvObj(context)
        
        checkItem = "CHECK_SOFTWARE_SYSALARM"
        logger.logExecCmd(checkItem)
        itemDict = tlvData.UPD_CHECK_RESULT[checkItem]#根据检查项获取配置字典值
        recs = tlvUtil.getUpgradeRecords(tlv, checkItem)
        logger.logInfo("records=%s" % unicode(recs))
        
        cli = contextUtil.getSSH(context)
        cliRet = constructCliRet(cli, logger, lang)
        
        for record in recs:
            result = tlvUtil.getRecordValue(record, tlvData.CMO_UPD_EXECUTE_DEFINE["RESULT"])
            #根据模块返回值获取对应的字典值,如果失败返回None
            itemVal = itemDict.get(result, None)
            if itemVal is None:
                errMsg += common.getMsg(lang, "query.result.abnormal")
                flag = False
                continue
            status = itemVal.get("status", None)
            if status is True:
                continue
            flag = False
            errMsg += common.getMsg(lang, itemVal["msg"])
        return common.getUpgEvaluationRs(flag, cliRet, errMsg)
    except Exception, exception:
        logger.logException(exception)
        return common.getUpgEvaluationRs(False, cliRet, common.getMsg(lang, "query.result.abnormal"))

def constructCliRet(cli, logger, lang):
    '''
    @summary: 构造CLI回显,若命令不存在则过滤掉不显示该回显
    '''
    cliRet = ""
    try:
        cmdList = ["show alarm_mask",
                   "show alarm level=major number=10",
                   "show alarm level=critical number=10"]
        #获取cli回显
        for cmd in cmdList:
            checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
            if not cliUtil.hasCliExecPrivilege(checkRet[1]):
                continue
            cliRet += checkRet[1] + "\n"
        
        return cliRet
    except Exception, exception: 
        logger.logException(exception)
        return cliRet


