# -*- coding: UTF-8 -*-
from frame.common import common
from frame.context import contextUtil
from frame.cli import cliUtil
import time
import os
from com.huawei.ism.tool.obase.utils import ManualConfigItemMgr

def execute(context):
    '''
    @summary: the entrance of main method, do preparing check before evaluation
    @param context: the dictionary of data which provided by tool framework
    @return: (pass status, CLI information, error message) as (boolean, string, string)
    '''
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    lang = contextUtil.getLang(context)
    cli = contextUtil.getSSH(context)
    item = "pre_check"
    try:
        flag = common.RESULT_PASS
        cliRet = ""
        errMsg = ""
        flagLst = []
        errMsgLst = []
        #检查设备状态
        flag, errMsg = isDeviceNormal(context)
        if common.RESULT_NOTPASS == flag:
            logger.logNoPass('check if the device is normal!')
            return (flag, cliRet, errMsg)

        #检查设备是否为单控模式
        upgradeModel = contextUtil.getUpgradeModel(context)
        funFlag = common.isSigleModel(cli, lang)
        if funFlag == True and upgradeModel == common.MODEL_ONLINE_UPGRADE:
            errMsg = common.getMsg(lang, "unsupport.single.online")
            logger.logNoPass('Single-Controller does not support online-upgrade evaluation!')
            return (common.RESULT_NOTPASS, cliRet, errMsg)

        common.setProgress(context, common.PROGRESS_NUM_1, item)

        funFlag, funErrMsg = isAdminUser(cli, lang)
        flagLst.append(funFlag)
        if common.RESULT_NOTPASS == funFlag:
            errMsgLst+=funErrMsg
            logger.logNoPass('check if it is admin user failed!')
        common.setProgress(context, common.PROGRESS_NUM_20, item)
        funFlag, funErrMsg = isDeviceVerValid(context)
        flagLst.append(funFlag)
        if common.RESULT_NOTPASS == funFlag:
            errMsgLst+=funErrMsg
            logger.logNoPass('check if device version is valid failed!')
        common.setProgress(context, common.PROGRESS_NUM_40, item)
        funFlag, funErrMsg = isVersionValid(context)
        flagLst.append(funFlag)
        if common.RESULT_NOTPASS == funFlag:
            errMsgLst+=funErrMsg
            logger.logNoPass('check if destination version is valid failed!')
        common.setProgress(context, common.PROGRESS_NUM_60, item)
        #获取集群所有控制器IP，并存入上下文中
        ctrlsIpsRet = cliUtil.getCtrlIps(cli, logger, lang)
        logger.logInfo('get all ctrollers ip result:%s' %str(ctrlsIpsRet))
        contextUtil.setItem(context, "allCtrlsIp", ctrlsIpsRet[1])
        common.setProgress(context, common.PROGRESS_NUM_80, item)
        if common.RESULT_NOTPASS in flagLst:
            flag = common.RESULT_NOTPASS

        for index in range(len(errMsgLst)):
            errMsg += common.getMsg(lang, "show.problems", (index+1,errMsgLst[index]))

        if not flag:
            CreateAndSaveTimestamp(context)
        return flag,cliRet,errMsg
    finally:
        logger.logInfo("the progress is 100")
        common.setProgress(context, common.PROGRESS_NUM_MAX, item)


def isAdminUser(cli, lang):
    '''
    @Function name      : isAdminUser
    @Function describe  : 判断当前用户权限级别是否是Super_admin登录
    @Input              : cli, lang
    @Return             : funFlag,funErrMsg
    '''
    funFlag = common.RESULT_NOTPASS
    funErrMsg = []
    
    checkRet = cliUtil.getUserPrivilege(cli, lang)
    if checkRet[0] != True:
        return (checkRet[0], checkRet[2])
    
    if checkRet[1].upper() == 'Super_admin'.upper():
        funFlag = common.RESULT_PASS
    else:
        funErrMsg.append(common.getMsg(lang, "user.authority.failure"))       
    return (funFlag, funErrMsg)

def isDeviceNormal(context):
    '''
    @summary: judge whether the device status is normal
    @param context: the context object provided by tool framework
    @return: the status of device which is normal or abnormal, as boolean
    '''
    funFlag = common.RESULT_PASS
    funErrMsg = ""
    errMsg = ""
    cliRet = ""
    cli = contextUtil.getSSH(context)
    lang = contextUtil.getLang(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    cmd = "show system general"
    checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
    if checkRet[0] != True:
        logger.logSysAbnormal()
        return (common.RESULT_NOTPASS, checkRet[2])
    
    cliRet = checkRet[1]
    cliRetLinesList = cliUtil.getVerticalCliRet(cliRet)
    if len(cliRetLinesList) == 0:
        return (common.RESULT_NOTPASS, errMsg)
    
    for retDict in cliRetLinesList:
        sysRunningStatus = retDict["Running Status"]
        sysHealthStatus = retDict["Health Status"]
        if sysRunningStatus != common.STATUS_NORMAL or sysHealthStatus != common.STATUS_NORMAL:
            funFlag = common.RESULT_NOTPASS
            logger.logNoPass('[pre_check]System status is not normal.')
            funErrMsg = common.getMsg(lang, "system.status.abnormal")
                
    return (funFlag, funErrMsg)

def isVersionValid(context):
    '''
    @Function name      : isVersionValid
    @Function describe  : 判断版本是否有效
    @Input              : context
    @Return             : funFlag,funErrMsg,devType
    '''

    funFlag = common.RESULT_PASS
    funErrMsg = []
    #源版本
    curVer = contextUtil.getCurVersion(context)
    #目标版本
    destVer = contextUtil.getTargetVersion(context)
    #语言环境
    lang = contextUtil.getLang(context)
    if ManualConfigItemMgr.getInstance().expected("permanent.support.downgrade", "yes"):
        return funFlag, funErrMsg
        
    #向框架提需求，目标版本不能为空
    #有效性检查（1）：输入的当前版本号不能为空  
    if not destVer:
        funFlag = common.RESULT_NOTPASS
        funErrMsg.append(common.getMsg(lang, "target.version.not.exist"))
    
    #有效性检查（2）：当前版本号与目标版本号不允许相同
    if curVer == destVer:
        funFlag = common.RESULT_NOTPASS
        funErrMsg.append(common.getMsg(lang, "original.equal.to.target"))
  
    #获取R版本和C版本信息
    curCVersionTmp = curVer[0:11]
    upgCVersionTmp = destVer[0:11]
    #TR5可能为空
    curSPCVersionTmp = curVer[11:]
    upgSPCVersionTmp = destVer[11:]    
    
            
    #有效性检查（3）：判断是否为回退
    #非回退检查
    rollbackFlag = False        
    #当前C版本大于目标C版本则提示不支持回退检查
    if curCVersionTmp > upgCVersionTmp:
        funFlag = common.RESULT_NOTPASS
        rollbackFlag = True
    #C版本相同
    elif curCVersionTmp == upgCVersionTmp:
        #当前SPC号大于目标SPC号则提示不支持回退检查
        if curSPCVersionTmp > upgSPCVersionTmp:
            funFlag = common.RESULT_NOTPASS
            rollbackFlag = True
    if rollbackFlag:
        funErrMsg.append(common.getMsg(lang, "original.less.to.target"))
    return funFlag, funErrMsg

def isDeviceVerValid(context, isContainSpc=True):
    '''
    @summary: 判断上下文中的版本信息是否有效
    @param context: 上下文
    @param containSPC: 比较版本信息时是否包含SPC版本的标记，默认包含SPC即比较时要精确到SPC版本版本。如果不包含SPC，则比较时，只比较V、R、C是否一致
    @return: 
        True: 版本一致
        False: 版本不一致
    '''
    lang = contextUtil.getLang(context)
    cli = contextUtil.getSSH(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    
    funFlag = common.RESULT_NOTPASS
    funErrMsg = []
    
    #从上下文中获取当前版本并转化为标准格式
    curVersion = common.formatVersion(contextUtil.getCurVersion(context))
    
    #从设备上获取当前版本
    flag, deviceVersion, cliRet = common.getDevVersion(cli, lang, logger)
    if flag == False:
        funErrMsg.append(common.getMsg(lang,"cannot.get.version"))
        return (funFlag, funErrMsg)
    
    #标准化设备版本
    deviceVersion = common.formatVersion(deviceVersion)
    
    if not isContainSpc:
        curVersion = common.getVrcVersion(curVersion)
        deviceVersion = common.getVrcVersion(deviceVersion)
    
    if curVersion == deviceVersion:
        funFlag = common.RESULT_PASS
    else:
        funErrMsg.append(common.getMsg(lang, "need.refresh.device", (deviceVersion,curVersion)))
    return funFlag, funErrMsg

def CreateAndSaveTimestamp(context):
    '''
    @summary: 设置当前设备的存放文件的临时目录，存放在上下文中
    '''
    curTime = time.strftime('%Y%m%d%H%M%S',time.localtime(time.time()))
    deviceSN = contextUtil.getDevSN(context)
    tmpFileName = deviceSN +"_" + curTime
    
    contextUtil.setItem(context, common.TMP_FILE_NAME, tmpFileName)
    return

