# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2024-2024. All rights reserved.

SCRIPT_DEF_CONTEXT = "SCRIPT_DEF_CONTEXT"


def get_lang(context):
    """
    @summary: 获取语言
    @param context: 上下文对象
    """
    return context.get("lang")


def get_logger(context):
    """
    @summary: 获取日志打印对象
    @param context: 上下文对象
    """
    return context.get("logger")


def get_dev_type(context):
    """
    @summary: 获取设备类型
    """
    return get_dev_obj(context).getDeviceModel()


def get_dev_sn(context):
    """
    @summary: 获取设备序列号Serial Number
    """
    return get_dev_obj(context).getDeviceSerialNumber()


def get_cur_version(context):
    """
    @summary: 获取系统当前版本
    @param context: 上下文对象
    """
    return get_dev_obj(context).getProductVersion()


def get_target_version(context):
    """
    @summary: 获取目标版本号
    @param context: 上下文对象
    """
    return get_dev_obj(context).getDestVersion()


def get_script_def_dict(context):
    """
    @summary: 获取上下文自定义字典
    @param context: 上下文对象
    """
    if isinstance(context, dict):
        if not context.has_key(SCRIPT_DEF_CONTEXT):
            context.setdefault(SCRIPT_DEF_CONTEXT, {})
    else:
        if not context.containsKey(SCRIPT_DEF_CONTEXT):
            context.put(SCRIPT_DEF_CONTEXT, {})
    return context.get(SCRIPT_DEF_CONTEXT)


def set_item(context, key, value):
    """
    @summary: 往自定义字典中添加项
    @param context: 上下文对象
    @param key: 添加项的键
    @param value: 添加项的值
    """
    script_def_dict = get_script_def_dict(context)
    script_def_dict[key] = value

    if isinstance(context, dict):
        context[SCRIPT_DEF_CONTEXT] = script_def_dict.copy()
    else:
        context.put(SCRIPT_DEF_CONTEXT, script_def_dict.copy())
    return


def remove_item(context, key):
    """
    @summary: 删除自定义字典中的项
    @param context: 上下文对象
    @param key: 删除项的键
    """
    script_def_dict = get_script_def_dict(context)
    if script_def_dict.has_key(key):
        script_def_dict.pop(key)
    return


def get_item(context, key):
    """
    @summary: 获取自定义字典中的项
    @param context: 上下文对象
    @param key: 项的键
    """
    script_def_dict = get_script_def_dict(context)
    return script_def_dict.get(key, None)


def get_connector_factory_obj(context):
    """
    @summary: 获取上下文对象中创建连接的对象
    @param context: 上下文对象
    """
    return context.get("sshFactory")


def get_new_dev_obj(context):
    """
    @summary: 获取上下文对象中dev_rest对象
    @param context: 上下文对象
    """
    return context.get("newDev")


def get_dev_obj(context):
    """
    @summary: 获取上下文对象中dev对象
    @param context: 上下文对象
    """
    return context.get("dev")


def get_upgrade_model(context):
    """
    @summary: 获取升级模式（在线或者离线），其值为"ONLINE"或"OFFLINE"
    @param context: 上下文对象
    """
    return str(get_dev_obj(context).getUpgradeMode())


def get_cli(context):
    return context.get('ssh')
