# -*- coding: UTF-8 -*-
import resource
from cbb.frame.cli import cliUtil
from cbb.frame.util.common import wrapAllExceptionLogged

STATUS_NORMAL = "Normal"
STATUS_FAULT = "Fault"
STATUS_ONLINE = "Online"
STATUS_RUNNING = "Running"
STATUS_CHARGING = "Charging"
STATUS_DISCHARGING = "Discharging"
STATUS_ENABLED = "Enabled"
STATUS_YES = "Yes"
STATUS_NO = "No"
STATUS_LINK_UP = "Link Up"
STATUS_LINK_DOWN = "Link Down"
STATUS_ON = "On"
STATUS_OFF = "Off"
STATUS_START = "Start"
STATUS_SYNCHRONIZING = "Synchronizing"
STATUS_PAUSED = "Paused"
STATUS_FORCE_STARTED = "Force Started"
STATUS_INIT = "INIT"

CONTROLLER_INFO = "controller [%s]:\n"
SUPPORT_PRODUCT_MODEL = ["2800 V3", "2800 V5"]
MODEL_ONLINE_UPGRADE = "ONLINE"

SLEEP_TIMES = 30
PORTS_BIT_ERROR_SPEC = 60
PORTS_BIT_ERROR_INTERVAL = 10
SERIAL_NUMBER_LENGTH = 20
THRESHOLD_BBU_REMAINING_LIFETIME = 90
THRESHOLD_CONTRL_CPU_USAGE = 80

RESULT_PASS = 0
RESULT_NOTPASS = 1
RESULT_NOCHECK = 2
RESULT_NOSUPPORT = 3
RESULT_WARNING = 4

FILE_SUFFIX = "."
EXPORT_TYPE_RUNNING_DATA = "running_data"
COLLECT_INFO_RECROD_STANDARD = "File Path :"
CONFIG_FILE = "config.txt"
TMP_FILE_NAME = "tmpFileName"

PROGRESS_NUM_1 = 1
PROGRESS_NUM_5 = 5
PROGRESS_NUM_10 = 10
PROGRESS_NUM_15 = 15
PROGRESS_NUM_20 = 20
PROGRESS_NUM_40 = 40
PROGRESS_NUM_60 = 60
PROGRESS_NUM_80 = 80
PROGRESS_NUM_MAX = 100


@wrapAllExceptionLogged(logger=None)
def setProgress(context, progress, item):
    observer = context.get("progressObserver")
    if observer is not None:
        observer.updateItemProgress(context.get("dev"), int(progress), item)


def getMsg(lang, msg, args=""):
    """
    @summary: 消息国际化
    @param lang: 语言lang
    @param msg: 消息
    @param args: 消息参数
    @return: 经过国际化处理后的消息
    """
    return cliUtil.getMsg(lang, msg, args, resource.MESSAGES_DICT)
