# -*- coding: UTF-8 -*-
"""
查询数据保护引擎版本号
"""
import traceback
from cbb.frame.base.exception import UnCheckException
from cbb.frame.cli import cliUtil
from cbb.frame.context import contextUtil
from java.lang import Exception as JException

HELM_INSTALL_NAME = "dataprotect"
NAMESPACE_NAME = "dpa"


def execute(context):
    logger = contextUtil.getLogger(context)
    lang = contextUtil.getLang(context)
    try:
        logger.info("get container version.")
        cmd = "show container_application general"
        cli = contextUtil.getCli(context)
        flag, cli_ret, err_msg = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
        logger.info("get container version cli_ret:{}".format(cli_ret))
        if flag is not True:
            raise UnCheckException("get container version is failed.")
        data = cliUtil.getHorizontalCliRet(cli_ret)[0]
        return True, data.get("Revision")
    except (Exception, JException) as e:
        logger.error("get container version is failed.Exception:{}".format(traceback.format_exc()))
        raise Exception(str(e))
