# -*- coding: UTF-8 -*-
from cbb.business.checkitems import SystemInnerCheck
from common import common

# 升级前检查类型
SYS_UPG_CHECK_TYPE = {
    "OFFLINE_CONTAINER": "A8000UpgradeEval",
    "PATCH_CONTAINER": "A8000PatchPreCheck",
}
# 界面状态 com.huawei.ism.tool.upgradeevalu.evalu.ResultFlag
STATUS_MAP_DICT = {
    "0": 7,  # 等待执行
    "1": 6,  # 执行中
    "2": 0,  # 执行成功
    "3": 1,  # 执行失败
    "4": 2,  # 执行错误
    "5": 3,  # 忽略
}
ITEM = "preUpgradeInnerCheck"


def execute(data_dict):
    data_dict['checkType'] = "PRECHECK"
    logger = data_dict.get("logger")
    dev = data_dict.get("dev")
    upgrade_type = str(dev.getUpgradeMode())
    logger.info("[PreCheck]user setted upgrade type is :" + upgrade_type)
    common.setProgress(data_dict, common.PROGRESS_NUM_5, ITEM)

    context = data_dict
    observer = UiObserver(data_dict)
    context["checkType"] = SYS_UPG_CHECK_TYPE.get(upgrade_type)

    context["observer"] = observer
    context["ignorePreCheckItems"] = data_dict.get("ignorePreCheckItems", "")
    context["supportItemsIgnore"] = data_dict.get('supportItemsIgnore')
    extras = {
        "targetVersion": str(dev.getDestVersion().split()[0]),
    }
    context["extras"] = extras
    logger.info("xx send extras=%s" % str(extras))
    common.setProgress(data_dict, 99, ITEM)
    check_obj = SystemInnerCheck.UpgradeCheck(context)

    flag, err_msg, ret = check_obj.execute()
    # 返回的格式：（检查结果，原始信息，错误描述）
    common.setProgress(data_dict, common.PROGRESS_NUM_MAX, ITEM)
    if flag:
        return "0", ret, ""
    return "1", ret, err_msg


class UiObserver():
    def __init__(self, data_dict):
        self.data_dict = data_dict
        self.logger = data_dict.get("logger")
        self.resource = data_dict.get("resource")
        self.lang = data_dict.get("lang")
        self.ui_update_msg = {}
        self.dev = self.data_dict.get("dev")
        self.ui_observer = self.data_dict.get("progressObserver")

    def postMsg(self, inner_items):
        # 先移除所有老的内部检查项，再加上新的
        self.ui_update_msg["checkitems"] = inner_items
        self.ui_observer.updateChildItems(
            self.dev,
            "preUpgradeInnerCheck",
            self.ui_update_msg)

    def toUiStatus(self, status):
        return STATUS_MAP_DICT.get(status, 7)

    def setProgress(self, progress):
        progress = int(progress * 0.9)
        # 执行下沉检查项的检查前，进度已经是1%了；int()是向下取整，可能会小于1；
        if progress <= 1:
            progress = 1
        self.dev.setEvaluProgress(progress)
        self.ui_observer.updateDevTableRow(self.dev)


class CheckStatus:
    PASS = "0"
    NOTPASS = "1"
    NOCHECK = "2"
    NO_SUPPORT = "3"
    WARNING = "4"
