# -*- coding: UTF-8 -*-
import contextUtil
import sysInfoManager
import resource
import cmdManager

# **************************************************************************** #
# 函数名称: checkLimit4InfModule
# 功能说明: 检查4口FCoE或TOE接口卡，低概率发生OOPS的问题
# 输入参数: devObj
# **************************************************************************** # 
def checkLimit4InfModule(dataDict):

    SYS_PATCH_VER_MAP = {
                         'V100R005C30SPC500':'V100R005C30SPH501',
                         'V100R005C30SPC700':'V100R005C30SPH701',
    }

    #限制收集的开始版本
    LimitStartVersion = "V100R005C02SPC300"
    #已经解决的版本
    SolvedStartVersion = "V100R005C30SPC700"

    logger = contextUtil.getLogger(dataDict)
    lang = contextUtil.getLang(dataDict)
    cliRetAll = ""
    
    try:
        #判断设备版本
        checkRet = sysInfoManager.getCurSystemVersion(dataDict)
        cliRetAll += checkRet[2]
        if not checkRet[0]:
            return (False, cliRetAll, resource.getMsg(lang, "cannot.get.sysversion"))
            
        curentVersion = checkRet[1]
        if curentVersion < LimitStartVersion or curentVersion > SolvedStartVersion:
            return (True, cliRetAll, "")
        
        (queryOk, existFlag, cliRet) = ifExistT4InfModule(dataDict)
        cliRetAll += cliRet
        if not queryOk:
            return (False, cliRetAll, resource.getMsg(lang, "query.result.abnormal"))    
        if not existFlag:
            return (True, cliRetAll, "")
        
        if curentVersion not in SYS_PATCH_VER_MAP.keys():
            logger.info("Log collection is not supported due to the compatibility issues of 4-port FCoE or TOE interface modules. ")
            return (False, cliRetAll, resource.getMsg(lang, "collect.version.limit"))
        
        checkRet = sysInfoManager.getCurHotPatchVersion(dataDict)
        cliRetAll += checkRet[2]
        if not checkRet[0]:
            return (False, cliRetAll, resource.getMsg(lang, "cannot.get.patchversion"))
        
        #获取需要安装的热补丁
        hotpatchVer = checkRet[1]
        needHotPatchVer = SYS_PATCH_VER_MAP.get(curentVersion)
        if not hotpatchVer or hotpatchVer < needHotPatchVer:
            logger.info("Install a patch of %s or a later version and then perform an evaluation." % needHotPatchVer)
            return (False, cliRetAll, resource.getMsg(lang, "collect.need.hotpatch", needHotPatchVer))
        
        return (True, cliRetAll, "")
        
    except Exception, ex:
        logger.logException(ex) 
        return (False, resource.getMsg(lang, "query.result.abnormal"))
    
    
# **************************************************************************** #
# 函数名称: ifExistT4InfModule
# 功能说明: 检查设备上是否存在4口FCoE或TOE接口卡
# 输入参数: cli
# **************************************************************************** # 
def ifExistT4InfModule(dataDict):
    existFlag = False
    cliRet = cmdManager.execCmd(dataDict, "showifmodule")
    lineList = cliRet.splitlines()
    #信息少于7行，查询信息失败
    if len(lineList) < 7:
        if "command operates successfully" in cliRet:
            return (True, existFlag, cliRet)
        return (False, existFlag, cliRet)
    for line in lineList:
        if not line.strip().startswith("Type"):
            continue
        if "4 x 10G FCoE Interface Module" in line or "4 x 10GE Interface Module" in line:
            existFlag = True
            return (True, existFlag, cliRet)
    return (True, existFlag, cliRet)


