#coding: UTF-8

import re
from sysInfoManager import isAfterSecure
from contextUtil import getLang, getLogger, getDeveloperPwd, getCurSysVer

#cli命令回文行数判断
G_CLI_INFO_NORMAL_ROW_MIN = 7

# **************************************************************************** #
# 函数名称: changeCli2Developer
# 功能说明: 从Cli模式进入developer模式
# 输入参数: devObj
# 输出参数: 无
# 返 回 值: True or False
# **************************************************************************** # 
def changeCli2Developer(devObj):

    ssh = devObj.get("ssh")
    curVer = getCurSysVer(devObj)
    developerPwd = ""

    # 调试密码从框架获取 modified 20131129 Begin
    try:
        developerPwd = getDeveloperPwd(devObj)
    except:
        return False
    
    #如果密码设置为空，则返回False
    if developerPwd == None or developerPwd == "":
        return False

    #判断是否为安全红线设备
    secureFlag = isAfterSecure(curVer)
    if secureFlag:
        temp = ssh.execCmd("developer")
        #安全红线后设备进入developer模式
        if re.search("Are you sure", temp, re.IGNORECASE):
            
            temp1 = ssh.execCmd("y")

            if re.search("Enter Password", temp1, re.IGNORECASE):
                temp2 = ssh.execCmdNoLog(developerPwd)
                if re.search("developer:", temp2, re.IGNORECASE):
                    return True
    else:
        calPwd = developerPwd
        temp = ssh.execCmd("developer")
        #安全红线前设备进入developer模式
        if re.search("Enter Password", temp, re.IGNORECASE):
            temp1 = ssh.execCmdNoLog(calPwd)
            if re.search("developer:", temp1, re.IGNORECASE):
                return True
    # 调试密码从框架获取 modified 20131129 End
        
    #进入developer模式失败，重新回到CLI模式
    changeAnyModel2Cli(ssh)
    return False

# **************************************************************************** #
# 函数名称: changeAnyModel2Cli
# 功能说明: 从任意模式退出到cli命令模式（不适用于心跳连接到对端的情况）
# 输入参数: ssh
# 输出参数: 无
# 返 回 值: True or False
# **************************************************************************** # 
def changeAnyModel2Cli(ssh):
    
    counter = 0
    while True:
        temp = ssh.execCmd("showsys")
        #非developer模式下，cli回文正确，则认为回到了cli
        if re.search("System Name", temp, re.IGNORECASE) \
            and not re.search("developer", temp, re.IGNORECASE):
                break
        #老版本在minisystem下直接exit会退出连接，需要重连
        elif re.search("minisystem>", temp, re.IGNORECASE):
            temp1 = ssh.execCmd("exit")
            if re.search("Are you sure", temp1, re.IGNORECASE):
                try:
                    ssh.execCmd("y")
                except:
                    ssh.reConnect()
                continue

        #其他情况下，直接exit
        else:
            temp1 = ssh.execCmd("exit")
            if re.search("Are you sure", temp1, re.IGNORECASE):
                ssh.execCmd("y")
        
        #单控的命令模式最多4层
        counter += 1
        if counter >= 4:
            break

# **************************************************************************** #
# 函数名称: changeDeveloper2Minisystem
# 功能说明: 从developer模式进入minisystem模式
# 输入参数: devObj
# 输出参数: 无
# 返 回 值: True or False
# **************************************************************************** # 
def changeDeveloper2Minisystem(devObj):
    
    ssh = devObj.get("ssh")
    #进入minisystem
    temp = ssh.execCmd("minisystem")
    if re.search("Are you sure", temp, re.IGNORECASE):
        temp1 = ssh.execCmd("y")

        if re.search("minisystem>", temp1, re.IGNORECASE):
            return True

    return False
    
# **************************************************************************** #
# 函数名称: changeCli2Debug
# 功能说明: 从Cli模式进入debug模式
# 输入参数: devObj
# 输出参数: 无
# 返 回 值: True or False
# **************************************************************************** # 
def changeCli2Debug(devObj):

    ssh = devObj.get("ssh")
    curVer = getCurSysVer(devObj)
    # 调试密码从框架获取 added 20131129 Begin
    #先判断调试密码是否为空
    calPwd = getDeveloperPwd(devObj)
    
    #如果密码设置为空，则返回False
    if not calPwd:
        return False
    # 调试密码从框架获取 added 20131129 End
    
    #判断是否为安全红线设备
    secureFlag = isAfterSecure(curVer)
    if secureFlag:
        return False

    #安全红线前的设备：先进入developer
    changeFlag = changeCli2Developer(devObj)
    if not changeFlag:
        return False
    
    
    temp = ssh.execCmd("debug")
    #V1R2直接进入debug
    if re.search("Storage:", temp, re.IGNORECASE):
        return True
    #V1R1仍需要再多输入一次密码
    elif re.search("Enter Password", temp, re.IGNORECASE):
        temp1 = ssh.execCmdNoLog(calPwd)
        if re.search("Storage:", temp1, re.IGNORECASE):
            return True
    #其他情况，返回失败
    else:
        pass
     
    #进入debug模式失败，重新回到CLI模式
    changeAnyModel2Cli(ssh)

    return False

# **************************************************************************** #
# 函数名称: changeCli2Mml
# 功能说明: 从Cli模式进入Mml模式
# 输入参数: devObj
# 输出参数: 无
# 返 回 值: True or False
# **************************************************************************** # 
def changeCli2Mml(devObj):

    ssh = devObj.get("ssh")
    if not changeCli2Debug(devObj):
        return False
    temp = ssh.execCmd("mml")
    if re.search("MML>", temp, re.IGNORECASE):
        return True
    return False
