# -*- coding: UTF-8 -*-

# **************************************************************************** #
# 函数名称: getMsg
# 功能说明: 获取错误码对应描述信息
# 输入参数: lang  语言环境
#        msg 描述信息key值
#        
# 输出参数: 无
# 返 回 值: 描述信息
# **************************************************************************** # 
def getMsg(lang, msg, args=""):
    errMsg = "\n--"
    
    try:
        if not MESSAGES_DICT.has_key(msg):
            return errMsg
        
        localeDict = MESSAGES_DICT.get(msg)
        if not localeDict.has_key(lang):
            return errMsg
        
        localeMsg = localeDict.get(lang)
        if "%s" in localeMsg or "%i" in localeMsg:
            return localeMsg % args
        else:
            return localeMsg
    except:
        return errMsg
    

# **************************************************************************** #
# 设备错误码描述信息
# **************************************************************************** #
MESSAGES_DICT = {
"cannot.get.sysversion":
    {
        "zh":u"无法获取产品版本信息。",
        "en":"Cannot get information about product version." ,
    },
"cannot.get.patchversion":
    {
        "zh":u"无法获取热补丁版本信息。",
        "en":"Cannot get information about patch version." ,
    },                 
"get.result.abnormal":
    {
        "zh":u"\n查询结果异常。",
        "en":"\nQuery result is abnormal.",
    },
"collect.version.limit":
    {
        "zh":u"\n由于4端口FCoE或TOE接口卡兼容性原因，不支持日志收集，请联系技术支持工程师进行处理。",
        "en":"\nLog collection is not supported due to the compatibility issues of 4-port FCoE or TOE interface modules. If you have any questions, contact Huawei technical support engineers.",
    },  
"collect.need.hotpatch":
    {
        "zh":u"\n请安装%s及之后的补丁，再执行评估。",
        "en":"\nInstall a patch of %s or a later version and then perform an evaluation. ",
    },                                
}
