﻿# -*- coding: UTF-8 -*-
'''
模块说明：该模块为常用功能模块
'''
import datetime
import time
from cbb.frame.util.common import wrapAllExceptionLogged

def getCurDateAndTime(format=''):
    '''
    @summary: get current date and time
    @param format: the format of date or time, as string
    @return: date and time as string
    '''
    microSecond = unicode(datetime.datetime.now().microsecond)
    #默认为17位时间戳，即精确到毫秒
    DEFAULT_FORMAT = '%Y%m%d%H%M%S' + microSecond[:3]
    if not format:
        format = DEFAULT_FORMAT
    nowDateAndTime = datetime.datetime.now()
    strTime = nowDateAndTime.strftime(format)
    return strTime


def reverseDict(dict2BReversed):
    '''
    @summary: reverse dictionary
    @param dict2BReversed: dictionary which need to be reversed
    @return: dictionary which has been reversed
    '''
    return dict(map(lambda t:(t[1],t[0]), dict2BReversed.items()))


@wrapAllExceptionLogged(logger=None)
def safeSleep(seconds):
    '''
    @summary: 睡眠
    @param seconds: 睡眠时间
    '''
    time.sleep(seconds)
