# -*- coding: UTF-8 -*-

from common.utils import safeSleep
from common.constant import CheckedResult
from common.cmdRetManager import getCliRet, checkCliInfoValid
from common.contextUtil import getLang, getLogger


def execute(dataDict):
    '''
    @summary: the entrance of main method, this check item is used to check CPU status
    @param dataDict: the dictionary of data which provided by tool framework
    @return: (pass status, CLI information, error message) as (boolean, string, string)
    '''
    flag = CheckedResult.PASS
    lang = getLang(dataDict)
    errMsg = ""
    controllerID = ""
    allcliRet = ''
    
    counter_A = 0
    counter_B = 0
    counter = 0
    CPUUtility_A = 0
    CPUUtility_B = 0
    AverageCpuUtility_A = 0
    AverageCpuUtility_B = 0

    while True:
        #初始化CPU利用率信息
        CPUUtility = 0
        cliRet = getCliRet(dataDict, "showcontroller")
        list = cliRet.splitlines()
        if len(list) < 7:
            #特定版本没有需要的信息，通过
            if "Controller Information" in cliRet:
                return (CheckedResult.PASS, cliRet, errMsg)
            if "zh" == lang:
                errMsg += u"\n未取到有效的控制器信息。"
            else:
                errMsg = "\nFailed to get controller information."
            return (CheckedResult.NOTPASS, cliRet, errMsg)

        for field in list:
            field = field.replace(" ", "").replace("|", "")
            
            if field.startswith("ControllerID"):
                controllerID = field.replace("ControllerID", "")
            elif field.startswith("CPUUtility(%)"):
                CPUUtility = int(field.replace("CPUUtility(%)", ""))
                
                #指定控制器CPU利用率信息取得
                if 'A' == controllerID:
                    counter_A += 1
                    CPUUtility_A += CPUUtility
                elif 'B' == controllerID:
                    counter_B += 1
                    CPUUtility_B += CPUUtility
                else:
                    break
        
        allcliRet += '\n' + cliRet
        
        counter += 1
        
        if counter >=4:
            break;
        else:
            safeSleep(5)
    
    #计算每个控制器的平均CPU利用率
    if counter_A != 0:
        AverageCpuUtility_A = CPUUtility_A / counter_A
    if counter_B != 0:
        AverageCpuUtility_B = CPUUtility_B / counter_B
    
    #控制器A的CPU利用率判断及错误信息打印
    if AverageCpuUtility_A >= 30:
        flag = CheckedResult.NOTPASS
        if "zh" == lang:
            errMsg += u"\n控制器A" + u"的CPU平均使用率为" + unicode(AverageCpuUtility_A)\
                        + u"%，不允许执行在线升级。"
        else:
            errMsg += "\nThe average CPU utility of controller A"\
                        + " is " + unicode(AverageCpuUtility_A) + "%, which can makes the online upgrade fail."
    
    #控制器B的CPU利用率判断及错误信息打印
    if AverageCpuUtility_B >= 30:
        flag = CheckedResult.NOTPASS
        if "zh" == lang:
            errMsg += u"\n控制器B" + u"的CPU平均使用率为" + unicode(AverageCpuUtility_B)\
                        + u"%，不允许执行在线升级。"
        else:
            errMsg += "\nThe average CPU utility of controller B"\
                        + " is " + unicode(AverageCpuUtility_B) + "%, which can makes the online upgrade fail."

    return (flag, allcliRet, errMsg)
