# -*- coding: UTF-8 -*-

import re
from common.constant import CheckedResult
from common.cmdRetManager import getCliRet, checkCliInfoValid
from common.contextUtil import getLang, getLogger



def execute(dataDict):
    '''
    @summary: the entrance of main method, this check item is used to check disk logical status
    @param dataDict: the dictionary of data which provided by tool framework
    @return: (pass status, CLI information, error message) as (boolean, string, string)
    '''

    flag = CheckedResult.PASS
    lang = getLang(dataDict)
    errMsg = ""
    
    normalStatus = "Normal|Free spare|Used spare"
    normalStatus = re.compile(normalStatus)

    cliRet = getCliRet(dataDict, "showdisk -logic", False)
    list = cliRet.splitlines()
    if len(list) < 7:
        #判断cli信息是否有效
        if not checkCliInfoValid(cliRet):
            flag = CheckedResult.NOTPASS
            if lang == "zh":
                errMsg = u"\nCli信息无效。"
            else:
                errMsg = "\nCli information invalid." 
        return (flag, cliRet, errMsg)

    for field in list[6:]:
        list2 = field.split()
        if len(list2) < 2:
            continue
        if not re.search(normalStatus, field):
            flag = CheckedResult.NOTPASS
            #取得硬盘逻辑状态
            logicStatus = ""
            if "Reconstruction" == list2[1]:
                logicStatus = "Reconstruction is in progress"
            elif "Copyback" == list2[1]:
                logicStatus = "Copyback is in process"
            else:
                logicStatus = list2[1]

            if "zh" == lang:
                errMsg += u"\n硬盘" + list2[0] + u"的逻辑状态存在异常（" + logicStatus + u"）。"
            else:
                errMsg += "\nThe logical status of disk " + list2[0] \
                          + " is abnormal(" + logicStatus + ")."

    return (flag, cliRet, errMsg)