# -*- coding: UTF-8 -*-

import re
from common.constant import CheckedResult
from common.cmdRetManager import getCliRet, checkCliInfoValid
from common.contextUtil import getLang, getLogger, getCurSysVer, getCliRet4UpgradePkgInfo



def execute(dataDict):
    '''
    @summary: the entrance of main method, this check item is used to check disk quantity
    @param dataDict: the dictionary of data which provided by tool framework
    @return: (pass status, CLI information, error message) as (boolean, string, string)
    '''

    allRet = ''
    flag = CheckedResult.PASS
    errMsg = ''
    
    log = getLogger(dataDict)
    lang = getLang(dataDict)

    #获取当前系统版本号
    CurrentVer = getCurSysVer(dataDict)
    allRet += getCliRet4UpgradePkgInfo(dataDict)

    #V100R005C02SPC300及以后版本不需要检查
    if CurrentVer >= "V100R005C02SPC300":
        return (flag, allRet, errMsg)

    #获取智能扫描信息
    cliRet = getCliRet(dataDict, "showdisk -physic", False)
    allRet += "\n" + cliRet
    #解析回文
    lineList = cliRet.splitlines()
    #硬盘信息小于7行，系统故障
    if len(lineList) < 7:
        #硬盘信息小于7行，系统故障
        flag = CheckedResult.NOTPASS
        if lang == "zh":
            errMsg = u"\nCli信息无效。"
        else:
            errMsg = "\nCli information invalid."
     
        return (flag, allRet, errMsg)
    
    #查询硬盘个数
    diskCounter = 0
    for line in lineList[6:]:
        list2 = line.split()
        if len(list2) < 2:
            continue
        #硬盘个数加一
        diskCounter += 1
        #硬盘个数大于216，检查警告
        if diskCounter > 216:
            flag = CheckedResult.NOTPASS
            if lang == "zh":
                errMsg = u"\n系统中的硬盘个数大于216块，检查不通过。"
            else:
                errMsg = "\nThe quantity of disks in the system is larger than 216, the check failed." 
            break
        else:
            continue

    #检查通过返回
    return (flag, allRet, errMsg)
