# -*- coding: UTF-8 -*-
from common.constant import CheckedResult
from common.cmdRetManager import getCliRet, checkCliInfoValid
from common.contextUtil import getLang, getLogger

def execute(dataDict):
    '''
    @summary: the entrance of main method, this check item is used to check BBU power
    @param dataDict: the dictionary of data which provided by tool framework
    @return: (pass status, CLI information, error message) as (boolean, string, string)
    '''
    flag = CheckedResult.PASS
    lang = getLang(dataDict)
    curspeedtemp = ""
    confspeedtemp = ""
    errMsg = ""
    
    cliRet = getCliRet(dataDict, "showfcspeed")       
    list = cliRet.splitlines()
    if len(list) < 7:
        #判断cli信息是否有效
        if not checkCliInfoValid(cliRet):
            flag = CheckedResult.NOTPASS
            if lang == "zh":
                errMsg = u"\nCli信息无效。"
            else:
                errMsg = "\nCli information invalid."
        return (flag, cliRet, errMsg)   
       
    for field in list[6:]:
        list2 = field.split()
        if len(list2) < 6:
            continue
        
        curspeedtemp = list2[4]
        confspeedtemp = list2[5]
        
        if curspeedtemp not in ("--", "AUTO", "2Gbps" ,"4Gbps" ,"8Gbps" )\
            or confspeedtemp not in ("--", "AUTO", "2Gbps" ,"4Gbps" ,"8Gbps" ):
            flag = CheckedResult.NOTPASS
            if "zh" == lang:
                errMsg += u"\nFC端口（Controller ID：" + list2[0] + u"，Interface Module ID：" + list2[1] + u"，Port ID：" + list2[2] \
                            + u"）的速率存在异常（" + u"当前速率为：" + curspeedtemp + u"，配置速率为：" + confspeedtemp + u"）。"
            else:
                errMsg += u"\nThe FC port (Controller ID:" + list2[0] + u", Interface Module ID:" + list2[1] + u", Port ID:"\
                            + list2[2] + u") is abnormal (Current Speed:" + curspeedtemp + u", Configured Speed:" + confspeedtemp + u")."

    return (flag, cliRet, errMsg)
