# -*- coding: UTF-8 -*-
from common.sysInfoManager import getCurHotPatchVersion, getCurDeviceType
from common.constant import CheckedResult, DeviceType
from common.contextUtil import getLang, getLogger, getCurSysVer, getCliRet4UpgradePkgInfo

def execute(dataDict):
    '''
    @summary: the entrance of main method, this check item is used to check hot patch before upgrade
    @param dataDict: the dictionary of data which provided by tool framework
    @return: (pass status, CLI information, error message) as (boolean, string, string)
    '''
    
    lang = getLang(dataDict)
    logger = getLogger(dataDict)

    cliRet = ''
    errMsg = ''
    needInstallHotPatch = "V100R001C00SPH402"

    #步骤1：获取设备类型(此次需要获取设备的实际型号，不能使用commonT的方法)
    sysInfo, deviceType = getCurDeviceType(dataDict)
    logger.info("DoradoV1 devcieType: %s." % unicode(deviceType))
    cliRet += sysInfo
    if DeviceType.UNKNOWN == deviceType:
        if "zh" == lang:
            errMsg += u"\n未取到有效的设备型号。"
        else:
            errMsg += "\nFailed to get system device type."
        return (CheckedResult.NOTPASS, cliRet, errMsg)
    
    if DeviceType.Dorado2100G2 != deviceType:
        return (CheckedResult.PASS, cliRet, errMsg)
    
    #步骤2：获取当前系统版本号
    CurrentVer = getCurSysVer(dataDict)
    logger.info("DoradoV1 current version: %s." % unicode(CurrentVer))
    cliRet += "\n" + getCliRet4UpgradePkgInfo(dataDict)
    
    if "V100R001C00SPC400" != CurrentVer:
        return (CheckedResult.PASS, cliRet, errMsg)
    
    #步骤3：获取当前已安装热补丁版本
    iRet = getCurHotPatchVersion(dataDict)
    processFlag = iRet[0]
    curHotPatchVer = iRet[1]
    cliRet += "\n" + iRet[2]
    if not processFlag:
        if "zh" == lang:
            errMsg += u"\n未获取有效的热补丁版本信息。"
        else:
            errMsg += "\nFailed to get hotpatch information."
        return (CheckedResult.NOTPASS, cliRet, errMsg)    
    
    if curHotPatchVer >= needInstallHotPatch:
        return (CheckedResult.PASS, cliRet, errMsg)
    else:
        if "zh" == lang:
            errMsg += u"请在升级前安装%s或者更高版本的热补丁。" % needInstallHotPatch
        else:
            errMsg += "Please install the hotpatch %s or a later version before performing the upgrade." % needInstallHotPatch
        return (CheckedResult.NOTPASS, cliRet, errMsg)
