# -*- coding: UTF-8 -*-
import re
from common.constant import CheckedResult
from common.cmdRetManager import getCliRet, checkCliInfoValid
from common.contextUtil import getLang, getLogger



def execute(dataDict):
    '''
    @summary: the entrance of main method, this check item is used to check Verifying LUN Consistency
    @param dataDict: the dictionary of data which provided by tool framework
    @return: (pass status, CLI information, error message) as (boolean, string, string)
    '''

    flag = CheckedResult.PASS
    errMsg = ""
    lang = getLang(dataDict) 
   
    cliRet = getCliRet(dataDict, "showlunverifying")
    list = cliRet.splitlines()
    if len(list) < 7:
        #判断cli信息是否有效
        if not checkCliInfoValid(cliRet):
            flag = CheckedResult.NOTPASS
            if lang == "zh":
                errMsg = u"\nCli信息无效。"
            else:
                errMsg = "\nCli information invalid."       
        return (flag, cliRet, errMsg)
    else:
        #回文信息大于7行，说明存在LUN的一致性校验
        flag = CheckedResult.NOTPASS
        if lang == "zh":
            errMsg = u"\n存在LUN在执行一致性校验，不能执行升级。"
        else:
            errMsg = "\nVerify LUN consistency is processing, can not support upgrade."
        return (flag, cliRet, errMsg)
