# -*- coding: UTF-8 -*-
from common.constant import CheckedResult
from common.cmdRetManager import getCliRet, checkCliInfoValid
from common.contextUtil import getLang, getLogger
from common.cTV1R1 import cHandleCliRet

def execute(dataDict):
    '''
    @summary: the entrance of main method, this check item is used to check LUN Status (Online)
    @param dataDict: the dictionary of data which provided by tool framework
    @return: (pass status, CLI information, error message) as (boolean, string, string)
    '''
    
    flag = CheckedResult.PASS
    lang = getLang(dataDict)
    log = getLogger(dataDict)
    errMsg = ""

    cliRet = getCliRet(dataDict, "showlun", False)
    
    #判断cli信息是否有效
    if not checkCliInfoValid(cliRet):
        flag = CheckedResult.NOTPASS
        if "zh" == lang:
            errMsg = u"\nCli信息无效。"
        else:
            errMsg = "\nCli information invalid."     
        return (flag, cliRet, errMsg)
    
    #使用通用接口解析命令回文
    formatFunction = cHandleCliRet(cliRet)
    lunInfoList = formatFunction.handle()
    log.info("All LUN number is:" + unicode(len(lunInfoList)))
    
    if len(lunInfoList) > 1024:
        flag = CheckedResult.NOTPASS
        if "zh" == lang:
            errMsg += u"\nLUN数量超过1024个，请参考修复建议进行处理。"
        else:
            errMsg += "\nThe number of LUNs exceeds 1024. Please perform operations as instructed in Recommended Suggestions."
    return (flag, cliRet, errMsg)
