# -*- coding: UTF-8 -*-

import re
import string
from common.constant import CheckedResult
from common.cmdRetManager import getCliRet, checkCliInfoValid
from common.contextUtil import getLang, getLogger



"""查询Lun负载均衡状态"""
def execute(dataDict):
    '''
    @summary: the entrance of main method, this check item is used to check LUN load balance status
    @param dataDict: the dictionary of data which provided by tool framework
    @return: (pass status, CLI information, error message) as (boolean, string, string)
    '''
    
    """
    showlun命令回显
    【V1R1】
    admin:/>showlun
    ====================================================================================================
                                              LUN Information                                           
    ----------------------------------------------------------------------------------------------------
      ID    RAID Group ID    Status    Controller    Capacity(MB)    LUN Name     Stripe Unit Size(KB)  
    ----------------------------------------------------------------------------------------------------
      0     --               Normal    A             4096.0          LUN001_1     64                    
      1     0                Normal    A             2048.0          LUN001_2     64         
    ====================================================================================================    
    【V1R2】
    admin:/>showlun
    =========================================================================================================================================
                                                                 LUN Information
    -----------------------------------------------------------------------------------------------------------------------------------------
      ID    RAID Group ID    Disk Pool ID    Status    Controller    Visible Capacity(MB)    LUN Name      Stripe Unit Size(KB)    Lun Type  
    -----------------------------------------------------------------------------------------------------------------------------------------
      0     0                --              Normal    A             1024.0                  LUN001_001    64                      FAT       
      1     0                --              Normal    B             1024.0                  LUN001_002    64                      FAT       
    =========================================================================================================================================
    """
    
    tempOwnController = ""
    tempWorkController = ""
    flag = CheckedResult.PASS
    lang = getLang(dataDict)
    errMsg = ""
    errCounter = 0
    
    cliRet = getCliRet(dataDict, "showlun", False)
    list = cliRet.splitlines()
    """判断cli回显信息是否满足要求"""
    if len(list) < 9:
        #判断cli信息是否有效
        if not checkCliInfoValid(cliRet):
            flag = CheckedResult.NOTPASS
            if lang == "zh":
                errMsg = u"\nCli信息无效。"
            else:
                errMsg = "\nCli information invalid."  
        return (flag, cliRet, errMsg)
    
    for field in list[6:]:
        
        luninfo = field.split()
        if len(luninfo) < 7:
            continue
        else:
            lunId = luninfo[0]
            #查询每一个LUN的负载均衡信息
            iRet = checklunloadbalance(dataDict, lunId)
            if CheckedResult.NOTPASS == iRet[0] and errCounter < 10:
                cliRet += '\n\n' + iRet[1]
                errCounter += 1
            tempOwnController = iRet[2]
            tempWorkController = iRet[3]
            #设置错误显示信息
            if CheckedResult.NOTPASS == iRet[0]:
                flag = CheckedResult.NOTPASS
                tuple2BReplaced = (unicode(lunId), unicode(tempOwnController), unicode(tempWorkController))
                if "zh" == lang:
                    errMsg += u"\nLUN[ID:%s]的负载不均衡, 所属控制器为%s,工作控制器为%s。" % tuple2BReplaced
                else:
                    errMsg += "\nThe load balance status of LUN[ID:%s] is not normal, Owning Controller is %s, Working Controller is %s." % tuple2BReplaced
    return (flag, cliRet, errMsg)
    

def checklunloadbalance(dataDict, lunId):
    
    """cli命令回显信息
    admin:/>showlun -lun 0    
    ===================================================================
                              LUN Information
    -------------------------------------------------------------------
      ID                           | 0
      Name                         | LUN001
      LUN WWN                      | 630397510068393001869d9b00000000
      Status                       | Normal
      Visible Capacity(MB)         | 57344.0
      Stripe Unit Size(KB)         | 64
      RAID Group ID                | 0
      Format Progress(%)           | --
      Owning Controller            | A
      Working Controller           | A
      Cache Prefetch Strategy      | Intelligent
      Cache Write Strategy         | Write back; Mirroring
      Running Cache Write Strategy | Write back; Mirroring
      Change stripped size         | --
      Stripe Unit Size Progress(%) | --
      Stripe Unit Size Speed       | --
      Extending LUN                | --
      Lun Type                     | FAT
      Consumed Capacity(MB)        | --
      Reclaim Progress(%)          | --
      Pool ID                      | --
      SnapShot ID                  | 6
      LunCopy ID                   | 0
      Whether Private LUN          | No
      Remote Replication ID        | 3039756839300000
      Split mirror ID              | --
    ===================================================================
        
    admin:/>"""
    #信息初始化
    OwnController = ''
    WorkController = ''
    flag = CheckedResult.PASS
    
    cliRet = getCliRet(dataDict, "showlun -lun " + unicode(lunId))
    list = string.split(cliRet, '\n')
    
    """判断cli回显信息是否满足要求"""
    count = len(list)
    for index in range(count):
        if re.search('Whether Private LUN', list[index], re.IGNORECASE):
            if re.search('Yes', list[index], re.IGNORECASE):
                return (CheckedResult.PASS, cliRet, '', '')
            else:
                break
        else:
            continue

    if count < 20:
        return(CheckedResult.NOTPASS, cliRet, '', '')

    """查询制定Lun的控制器信息"""
    #V1R1和V1R2版本的showlun详细信息中归属和工作控制器位置相同。
    OwnController = (list[12].split())[3]
    WorkController = (list[13].split())[3] 
    
    if OwnController != WorkController:
        flag = CheckedResult.NOTPASS
    return(flag, cliRet, unicode(OwnController), unicode(WorkController))

 