# -*- coding: UTF-8 -*-
import re
import traceback
from common.constant import CheckedResult
from common.cmdRetManager import getCliRet, checkCliInfoValid
from common.contextUtil import getLang, getLogger, getSshObj
from common.modelManager import *

def execute(dataDict):
    '''
    @summary: the entrance of main method, this check item is used to check LUN Reservation Status
    @param dataDict: the dictionary of data which provided by tool framework
    @return: (pass status, CLI information, error message) as (boolean, string, string)
    '''

    flag = CheckedResult.PASS
    cliRet = ''
    errMsg = ''
    notSupportFlag = 'Error: The current configuration can not support this function'
    
    lang = getLang(dataDict) 
    ssh = getSshObj(dataDict)
    log = getLogger(dataDict)
    try:
        cliRet = getCliRet(dataDict, "showlun", False)
        lineList = cliRet.splitlines()
        if len(lineList) < 7:
            #判断cli信息是否有效
            if not checkCliInfoValid(cliRet):
                flag = CheckedResult.NOTPASS
                if lang == "zh":
                    errMsg = u"\nCLI信息无效。"
                else:
                    errMsg = "\nInvalid CLI information."          
            return (flag, cliRet, errMsg)
        
        if not changeCli2Developer(dataDict):
            flag = CheckedResult.WARN
            if lang == "zh":
                errMsg = u"进入developer模式失败，查询LUN预留状态失败。失败的原因可能为：\n" \
                        + u"（1）添加设备时未输入developer密码。\n（2）添加设备时输入的developer密码无效。"
            else:
                errMsg = "Login to developer model failed, can not get LUN reservation state. The reason of failure may be:\n" \
                        + "(1) Did not enter a developer password when adding the device.\n(2) The developer password entered is incorrect."
            return (flag, cliRet, errMsg)
        
        for field in lineList[6:]:
            list2 = field.split()
            if len(list2) < 4:
                break
            lunId = list2[0]
            reserveInfo = ssh.execCmd('showscsireserve -lun ' + lunId)
            cliRet += '\n' + reserveInfo
            if 'The object does not exist' in reserveInfo:      #表示该LUN是私有LUN,不能映射给主机使用
                continue
            #特殊老版本查询命令不支持
            if notSupportFlag in reserveInfo:
                continue
            
            model = 'Reserve\s+State\s+\|\s+[^0]'
            reserveState = re.findall(model, reserveInfo)
            if reserveState:
                flag = CheckedResult.NOTPASS
                if lang == "zh":
                    errMsg += u'\nLUN（ID：' + lunId + u'）开启了预留。'
                else:
                    errMsg += '\nLUN(ID:' + lunId + ') reservation is enabled.'
        return (flag, cliRet, errMsg)
    except Exception,exception:
        log.error("TV1[lunReserve] catch except of arguement:" + unicode(exception.args))
        log.error("TV1[lunReserve] catch except of messages:" + unicode(exception))
        log.error("TV1[lunReserve] catch except of trace back:" + unicode(traceback.format_exc()))
        return (CheckedResult.NOTPASS, cliRet, errMsg)
    finally:
        changeAnyModel2Cli(ssh)     #切换到CLI模式
        