# -*- coding: UTF-8 -*-
import re
import traceback
from common.constant import CheckedResult
from common.cmdRetManager import getCliRet, checkCliInfoValid
from common.contextUtil import getLang, getLogger, getSshObj
from common.modelManager import *

def execute(dataDict):
    '''
    @summary: the entrance of main method, this check item is used to check LUN Reservation Status
    @param dataDict: the dictionary of data which provided by tool framework
    @return: (pass status, CLI information, error message) as (boolean, string, string)
    '''

    flag = CheckedResult.PASS
    cliRet = ''
    errMsg = ''

    lang = getLang(dataDict) 
    ssh = getSshObj(dataDict)
    log = getLogger(dataDict)
    try:
        cliRet = getCliRet(dataDict, "showlun", False)
        lineList = cliRet.splitlines()
        if len(lineList) < 7:
            #判断cli信息是否有效
            if not checkCliInfoValid(cliRet):
                flag = CheckedResult.NOTPASS
                if lang == "zh":
                    errMsg = u"\nCLI信息无效。"
                else:
                    errMsg = "\nInvalid CLI information."          
            return (flag, cliRet, errMsg)

        iRet = changeCli2Mml(dataDict)
        if not iRet:
            flag = CheckedResult.WARN
            log.info('TV1[lunReserve]failed to login to MML model.')
            if lang == "zh":
                errMsg = u"进入MML模式失败，查询LUN预留状态失败。失败的原因可能为：\n" \
                    + u"（1）添加设备时未输入developer密码。\n（2）添加设备时输入的developer密码无效。"
            else:
                errMsg = "Login to MML model failed, can not get LUN reservation state. The reason of failure may be:\n" \
                    + "(1) Did not enter a developer password when adding the device.\n(2) The developer password entered is incorrect."
        else:
            lunScsiInfo = ssh.execCmd('scsi getallreserve')
            cliRet += '\n' + lunScsiInfo
            if not re.search('ReserveState', lunScsiInfo):       #没有scsi getallreserve命令，则执行scsi getall命令
                lunScsiInfo = ssh.execCmd('scsi getall')
                cliRet += '\n' + lunScsiInfo
            if not re.search('ReserveState', lunScsiInfo):       #命令执行失败
                flag = CheckedResult.NOTPASS
                log.info('TV1[lunReserve]failed to run the scsi getall command.')
                if lang == "zh":
                    errMsg += u'\nMML信息无效。'
                else:
                    errMsg += "\nInvalid MML information."
            else:
                oldVerModel = 'Dev\s*Lun\([0-9]+\)\s+ReserveState\([^0]\)'
                reserveInfo = re.findall(oldVerModel, lunScsiInfo)
                
                if reserveInfo:     #存在预留检查不通过
                    flag = CheckedResult.NOTPASS
                    for lunReserve in reserveInfo:
                        if lang == "zh":
                            errMsg += u'\nLUN（ID：' + re.findall('[0-9]+', lunReserve)[0] + u'）开启了预留。'
                        else:
                            errMsg += '\nLUN(ID:' + re.findall('[0-9]+', lunReserve)[0] + ') reservation is enabled.'
        return (flag, cliRet, errMsg)
    except Exception,exception:
        log.error("TV1[lunReserve] catch except of arguement:" + unicode(exception.args))
        log.error("TV1[lunReserve] catch except of messages:" + unicode(exception))
        log.error("TV1[lunReserve] catch except of trace back:" + unicode(traceback.format_exc()))
        return (CheckedResult.NOTPASS, cliRet, errMsg)
    finally:
        changeAnyModel2Cli(ssh)     #切换到CLI模式
        