# -*- coding: UTF-8 -*-
import re
from common.constant import CheckedResult
from common.cmdRetManager import getCliRet, checkCliInfoValid, checkCliInfoValid
from common.contextUtil import getLang, getLogger
from common.cTV1R1 import *
from common.utils import *


def execute(dataDict):
    '''
    @summary: the entrance of main method, this check item is used to check LUN Status (Online)
    @param dataDict: the dictionary of data which provided by tool framework
    @return: (pass status, CLI information, error message) as (boolean, string, string)
    '''
    
    flag = CheckedResult.PASS
    lang = getLang(dataDict)
    errMsg = ""

    cliRet = getCliRet(dataDict, "showlun", False)
    
    #判断cli信息是否有效
    if not checkCliInfoValid(cliRet):
        flag = CheckedResult.NOTPASS
        if lang == "zh":
            errMsg = u"\nCli信息无效。"
        else:
            errMsg = "\nCli information invalid."           
        return (flag, cliRet, errMsg)
    
    #使用通用接口解析命令回文
    formatFunction = cHandleCliRet(cliRet)
    ctrlInfoList = formatFunction.handle()

    for ctrlInfo in ctrlInfoList:
        #获取Lun信息
        lunId = ctrlInfo.get('Id')
        lunStatus = ctrlInfo.get('Status')
        
        if lunStatus != "Normal":
            flag = CheckedResult.NOTPASS
            if "zh" == lang:
                errMsg += u"\nLUN（ID：" + lunId + u"）的状态存在异常（" + lunStatus + u"）。"
            else:
                errMsg += "\nThe status of LUN(ID:" + lunId +") is abnormal(" + lunStatus + ")."
    
    return (flag, cliRet, errMsg)
