# -*- coding: UTF-8 -*-
import re
from common.constant import CheckedResult
from common.cmdRetManager import getCliRet, checkCliInfoValid
from common.contextUtil import getLang, getLogger, getSshObj, getCurSysVer, getCliRet4UpgradePkgInfo
from common.modelManager import changeCli2Developer


def execute(dataDict):
    '''
    @summary: the entrance of main method, this check item is used to check scanning medium
    @param dataDict: the dictionary of data which provided by tool framework
    @return: (pass status, CLI information, error message) as (boolean, string, string)
    '''

    allRet = ''
    flag = CheckedResult.PASS
    errMsg = ''
    checkRetTmp = None
    developerFlag = False
    
    ssh = getSshObj(dataDict)
    log = getLogger(dataDict)
    lang = getLang(dataDict)

    #安全红线后的设备切换到developer模式
    if not changeCli2Developer(dataDict):
        flag = CheckedResult.WARN
        if lang == "zh":
            errMsg = u"进入developer模式失败，查询介质扫描数据失败。失败的原因可能为：\n" \
                    + u"（1）添加设备时未输入developer密码。\n（2）添加设备时输入的developer密码无效。"
        else:
            errMsg = "Login to developer model failed, can not get media scan information. The reason of failure may be:\n" \
                    + "(1) Did not enter a developer password when adding the device.\n(2) The developer password entered is incorrect."
        return (flag, allRet, errMsg)
    
    #获取智能扫描信息
    mediaScanInfo = ssh.execCmd("showmediascan")
    allRet += "\n" + mediaScanInfo
    lineList = mediaScanInfo.splitlines()
    if len(lineList) < 7:
        #判断cli信息是否有效
        if not checkCliInfoValid(mediaScanInfo):
            flag = CheckedResult.NOTPASS
            if lang == "zh":
                errMsg = u"\nCli信息无效。"
            else:
                errMsg = "\nCli information invalid."
        #退回到cli模式后返回
        ssh.execCmd("exit")        
        return (flag, allRet, errMsg)

    for line in lineList:
        if re.search("Status", line, re.IGNORECASE):
            if re.search("Executing", line, re.IGNORECASE):
                flag = CheckedResult.NOTPASS
                if lang == "zh":
                    errMsg = u"\n介质扫描功能已经开启，不允许执行升级。"
                else:
                    errMsg = "\nMedia Scan is executing, the system can not perform upgrade." 
            #查出状态值，退出循环
            break
        else:
            continue
                
    #退回到cli模式
    ssh.execCmd("exit")
    
    #检查通过返回
    return (flag, allRet, errMsg)
