# -*- coding: UTF-8 -*-
import re     
from common.constant import CheckedResult
from common.cmdRetManager import getCliRet, checkCliInfoValid
from common.contextUtil import getLang, getLogger, getUpgradeModel

def execute(dataDict):
    '''
    @summary: the entrance of main method, this check item is used to check memory capacity
    @param dataDict: the dictionary of data which provided by tool framework
    @return: (pass status, CLI information, error message) as (boolean, string, string)
    '''

    flag = CheckedResult.PASS
    errMsg = ""
    lang = getLang(dataDict)
   
    cliRet = getCliRet(dataDict, "showcache")
    list = cliRet.splitlines()
    if len(list) < 7:
        #小于7行，Cli信息无效;但对于V1R1C00SPC100\SPC200版本命令不存在时，通过
        if not checkCliInfoValid(cliRet):
            flag = CheckedResult.NOTPASS
            if lang == "zh":
                errMsg = u"\nCli信息无效。"
            else:
                errMsg = "\nCli information invalid."          
        return (flag, cliRet, errMsg)
    
    #获取所有控制器内存大小
    memCapacityList = []
    for field in list:
        if re.search("Total Memory Capacity", field, re.IGNORECASE):
            list2 = field.split("|")
            if len(list2) == 2:
                memCapacity = list2[1].strip()
                memCapacityList.append(memCapacity)
    
    #获取内存信息失败
    if len(memCapacityList) == 0 or len(memCapacityList) > 2:
        flag = CheckedResult.NOTPASS
        if lang == "zh":
            errMsg = u"\n获取控制器内存信息失败。"
        else:
            errMsg = "\nGetting memory capacity data failed."          
        return (flag, cliRet, errMsg)
    #获取双控信息
    else:
        #两端内存不一致，不允许升级
        if memCapacityList[0] != memCapacityList[1]:
            flag = CheckedResult.NOTPASS
            if lang == "zh":
                errMsg = u"\n两端控制器内存不一致，不能执行升级。"
            else:
                errMsg = "\nThe memory capacity of two controllers are not same, can not support upgrade."
            return (flag, cliRet, errMsg)
    
    #检查通过返回
    return (flag, cliRet, errMsg)
