# -*- coding: UTF-8 -*-
import re 
from common.constant import CheckedResult
from common.cmdRetManager import getCliRet, checkCliInfoValid
from common.contextUtil import getLang, getLogger



def execute(dataDict):
    '''
    @summary: the entrance of main method, this check item is used to check optical transceiver status
    @param dataDict: the dictionary of data which provided by tool framework
    @return: (pass status, CLI information, error message) as (boolean, string, string)
    '''
    flag = CheckedResult.PASS
    lang = getLang(dataDict)
    errMsg = ""
    
   
    cliRet = getCliRet(dataDict, "showfibremodule")
    list = cliRet.splitlines()
    if len(list) < 7:
        #判断cli信息是否有效
        if not checkCliInfoValid(cliRet):
           flag = CheckedResult.NOTPASS
           if lang == "zh":
               errMsg = u"\nCli信息无效。"
           else:
               errMsg = "\nCli information invalid."        
        return (flag, cliRet, errMsg)

    for field in list[6:]:
        list2 = field.split()
        if len(list2) < 9:
            continue
        if "Normal" not in list2:
            flag = CheckedResult.NOTPASS
            if "zh" == lang:
                errMsg += u"\n控制器" + list2[0] + u"上的框" + list2[1]\
                          + u"上的模块" + list2[4] + u"的端口" + list2[5]\
                          + u"的状态存在异常。"
            else:
                errMsg += "\nThe optical transceiver status of port " + list2[5]\
                          + " of module " + list2[4] + " of enclosure " + list2[1]\
                          +  " of controller " + list2[0] + " is abnormal."

    return (flag, cliRet, errMsg)