# -*- coding: UTF-8 -*-

import string
import re
from common.constant import CheckedResult
from common.cmdRetManager import getCliRet, checkCliInfoValid
from common.contextUtil import getLang, getLogger



def execute(dataDict):
    '''
    @summary: the entrance of main method, this check item is used to check Remote Replications
    @param dataDict: the dictionary of data which provided by tool framework
    @return: (pass status, CLI information, error message) as (boolean, string, string)
    '''
    """
    showrmtrep
    =================================================================================================
                                     Remote Replication Information
    -------------------------------------------------------------------------------------------------
      Name                    ID                  Mode            Is CG Member    Status    Role     
    -------------------------------------------------------------------------------------------------
      RemoteReplication001    0022A10B6C5C0000    Asynchronous    No              Normal    Primary  
    =================================================================================================
    """"""
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy
    Return             : the checkitem is pass;cli source info
    """
    flag = CheckedResult.PASS
    lang = getLang(dataDict)
    errMsg = ""
    
    cliRet = getCliRet(dataDict, "showrmtrep")
    list = cliRet.splitlines()
    if len(list) < 7:
        #判断cli信息是否有效
        if not checkCliInfoValid(cliRet):
            flag = CheckedResult.NOTPASS
            if lang == "zh":
                errMsg = u"\nCli信息无效。"
            else:
                errMsg = "\nCli information invalid."          
        return (flag, cliRet, errMsg)

    for field in list[6:]:
        list2 = field.split()
        if len(list2) < 5:
            continue
        
        #查询远程复制的运行状态
        if "Normal" != list2[4]:
            flag = CheckedResult.NOTPASS
            if "zh" == lang:
                errMsg += u"\n远程复制" + list2[1] + u"的状态存在异常（" + list2[4] + u"）。"
            else:
                errMsg += "\nThe status of remote replication " + list2[1]\
                          + " is abnormal(" + list2[4] + ")."
            continue

        #查询远程复制的详细状态信息
        rmtrepId = list2[1]
        iRet = checkRemoteReplication(dataDict, rmtrepId, lang)
        #取得回显信息和健康状态
        cliRet += '\n\n' + iRet[1]
        errMsg += iRet[2]
        #设置错误显示信息
        if CheckedResult.NOTPASS == iRet[0]:
            flag = CheckedResult.NOTPASS
        
        
    return (flag, cliRet, errMsg)


# **************************************************************************** #
# 函数名称: checkRemoteReplication
# 功能说明: 查询指定远程复制的健康状态
# 输出参数: 无
# **************************************************************************** # 
def checkRemoteReplication(dataDict, rmtrepId, lang):
    
    """cli命令回显信息
    >showrmtrepmember -rep 0022A10B6C5C0000
    ===================================================================================
                              Remote Replication Information
    -----------------------------------------------------------------------------------
      ID                  LUN ID    Array SN                Relation    Health Status  
    -----------------------------------------------------------------------------------
      0022A10B6C5C0000    2         210235G6T8Z0C4000006    Primary     Normal         
      0022A10B6C5C0000    3         210235G6T8Z0C4000007    Secondary     Normal         
    ==================================================================================="""
    #信息初始化
    flag = CheckedResult.PASS
    LunID = ""
    ArraySN = ""
    healthstatus = ''
    errMsg = ""
    cliRet = ""
    
    checkCmd = "showrmtrepmember -rep " + unicode(rmtrepId)
    cliRet = getCliRet(dataDict, checkCmd)
    list = string.split(cliRet, '\n')
    
    """判断cli回显信息是否满足要求"""
    count = len(list)
    if count < 7:
        if not checkCliInfoValid(cliRet):
            flag = CheckedResult.NOTPASS
            if lang == "zh":
                errMsg = u"\nCli信息无效（命令：" + checkCmd + u"）。"
            else:
                errMsg = "\nCli information invalid (Command:" + checkCmd + ")."
        return(flag, cliRet, errMsg)

    """查询所有的Lun"""
    for line in list[6:]:
        
        field = line.split()
        if len(field) < 5:
            continue

        LunID = field[1]
        ArraySN = field[2]
        Relation = field[3]
        healthstatus = field[4]
        
        """查询远程复制的健康状态"""
        if "Normal" != healthstatus:
            flag = CheckedResult.NOTPASS
            if "zh" == lang:
                errMsg += u"\n远程复制" + rmtrepId + u"（Array SN：" + ArraySN + u"；Lun Id：" + LunID + u"）的健康状态存在异常（" + healthstatus + u"）。"
            else:
                errMsg += "\nThe health status of remote replication " + rmtrepId + "(Array SN:" + ArraySN+ "; Lun Id:" + LunID\
                          + ") is abnormal(" + healthstatus + ")."
            continue
        
        """查询远程复制从端的Pair Status"""
        if Relation == "Secondary":
            checkCmd = "showrmtrepmember -rep " + unicode(rmtrepId) + " -sn " +  ArraySN + " -lun " + LunID
            tempInfo = getCliRet(dataDict, checkCmd)
            list = tempInfo.splitlines()
            cliRet += tempInfo
            if len(list) < 7:
                if not checkCliInfoValid(tempInfo):
                    flag = CheckedResult.NOTPASS
                    if lang == "zh":
                        errMsg += u"\nCli信息无效（命令：" + checkCmd + u"）。"
                    else:
                        errMsg += "\nCli information invalid (Command:" + checkCmd + ")."
                continue
            
            for line in list:
                if re.search("Pair Status", line, re.IGNORECASE):
                    field = line.split()
                    temp = field[-1]
                    if temp != "Splited":
                        flag = CheckedResult.NOTPASS
                                      
                        if "zh" == lang:
                            errMsg += u"\n远程复制" + rmtrepId + u"的从端（Array SN：" + ArraySN + u"；Lun Id：" + LunID + u"）的Pair Status不是Splited。"
                        else:
                            errMsg += "\nThe secondary array's Pair Status of remote replication " + rmtrepId + " (Array SN:" + ArraySN+ "; Lun Id:" + LunID\
                                      + ") is not Splited."
                    break
                else:
                    continue
            
    return(flag, cliRet, errMsg)

"""P11G-5580 检查远程复制状态巡检项修改 20121204 modified End"""
#P11G-5870 远程复制检查项优化 modified 20130713 End
