# -*- coding: UTF-8 -*-
from common.constant import CheckedResult
from common.cmdRetManager import getCliRet, checkCliInfoValid
from common.contextUtil import getLang, getLogger

def execute(dataDict):
    '''
    @summary: the entrance of main method, this check item is used to check Thin Pool Status
    @param dataDict: the dictionary of data which provided by tool framework
    @return: (pass status, CLI information, error message) as (boolean, string, string)
    '''

    flag = CheckedResult.PASS
    errMsg = ""
    lang = getLang(dataDict) 
   
    cliRet = getCliRet(dataDict, "showpool")
    lineList = cliRet.splitlines()
    if len(lineList) < 7:
        #判断cli信息是否有效
        if not checkCliInfoValid(cliRet):
            flag = CheckedResult.NOTPASS
            if lang == "zh":
                errMsg = u"\nCli信息无效。"
            else:
                errMsg = "\nCli information invalid."          
        return (flag, cliRet, errMsg)
    
    #查询pool状态
    if "RAID" in lineList[6]:
        poolStatus = lineList[6].split()[1]
        if poolStatus != "Normal":
            flag = CheckedResult.NOTPASS
            if 'zh' == lang:
                errMsg = u"\n系统资源池状态异常（" + poolStatus + u"）。"
            else:
                errMsg = "\nThe status of system pool is abnormal (" + poolStatus + ")."
    else:
        flag = CheckedResult.NOTPASS
        if lang == "zh":
            errMsg = u"\n资源池信息无效。"
        else:
            errMsg = "\nInvalid pool information."
    return (flag, cliRet, errMsg)
