# -*- coding: UTF-8 -*-

import re 
from common.constant import CheckedResult
from common.cmdRetManager import getCliRet, checkCliInfoValid
from common.contextUtil import getLang, getLogger



def execute(dataDict):
    '''
    @summary: the entrance of main method, this check item is used to check system status
    @param dataDict: the dictionary of data which provided by tool framework
    @return: (pass status, CLI information, error message) as (boolean, string, string)
    '''
    flag = CheckedResult.PASS
    lang = getLang(dataDict)
    errMsg = ""

    cliRet = getCliRet(dataDict, "showsys")
    list = cliRet.splitlines()
    
    if len(list) < 7:
        #判断cli信息是否有效
        if not checkCliInfoValid(cliRet):
            flag = CheckedResult.NOTPASS
            if lang == "zh":
                errMsg = u"Cli信息无效。"
            else:
                errMsg = "Cli information invalid."
        return (flag, cliRet, errMsg)   
    
    for field in list:
        if field.startswith("  Current System Mode"):
            if "Normal" not in field:
                flag = CheckedResult.NOTPASS
                if "zh" == lang:
                    errMsg += u"\n系统运行存在异常（" + field[field.index("|") + 2:].strip() + u"）。"
                else:
                    errMsg += "\nThe system runs abnormally(" + field[field.index("|") + 2:].strip()\
                              + ")."

    return (flag, cliRet, errMsg)
