# -*- coding: UTF-8 -*-

import re 
from common.constant import CheckedResult
from common.cmdRetManager import getCliRet, checkCliInfoValid
from common.contextUtil import getLang, getLogger



def execute(dataDict):
    '''
    @summary: the entrance of main method, this check item is used to check system temperature
    @param dataDict: the dictionary of data which provided by tool framework
    @return: (pass status, CLI information, error message) as (boolean, string, string)
    '''
    
    flag = CheckedResult.PASS
    lang = getLang(dataDict)
    errMsg = ""

    cliRet = getCliRet(dataDict, "showsystemp")
    list = cliRet.splitlines()
    if len(list) < 7:
        #判断cli信息是否有效
        if not checkCliInfoValid(cliRet):
            flag = CheckedResult.NOTPASS
            if lang == "zh":
                errMsg = u"Cli信息无效。"
            else:
                errMsg = "Cli information invalid."
        return (flag, cliRet, errMsg)

    for field in list[6:]:
        list2 = field.split()
        if len(list2) < 2:
            continue
        elif list2[1] == "--":
            continue
        elif int(list2[1]) >= 52:
            flag = CheckedResult.NOTPASS
            if "zh" == lang:
                errMsg += u"\n框" + list2[0] + u"的温度过高（" + list2[1] + u"℃）。"
            else:
                errMsg += "\nThe temperature(Celsius) of enclosure " \
                          + list2[0] + " is too high(" + list2[1] + ")."
        elif int(list2[1]) <= 5:
            flag = CheckedResult.NOTPASS
            if "zh" == lang:
                errMsg += u"\n框" + list2[0] + u"的温度过低（" + list2[1] + u"℃）。"
            else:
                errMsg += "\nThe temperature(Celsius) of enclosure " \
                          + list2[0] + " is too low(" + list2[1] + ")."
                
    return (flag, cliRet, errMsg)