# -*- coding: UTF-8 -*-
from common.sysInfoManager import getCurDeviceType
from common.constant import CheckedResult, DeviceType
from common.contextUtil import getLang, getLogger, getCurSysVer, getDestVer, getCliRet4UpgradePkgInfo, getUpgradeModel

def execute(dataDict):
    '''
    @summary: the entrance of main method, this check item is used to check hot patch before upgrade
    @param dataDict: the dictionary of data which provided by tool framework
    @return: (pass status, CLI information, error message) as (boolean, string, string)
    '''
    
    lang = getLang(dataDict)
    logger = getLogger(dataDict)

    cliRet = ''
    errMsg = ''
    flag = CheckedResult.PASS

    #步骤1：获取设备类型(此次需要获取设备的实际型号，不能使用commonT的方法)
    sysInfo, deviceType = getCurDeviceType(dataDict)
    logger.info("DoradoV1 VerLimitCheck devcieType: %s." % unicode(deviceType))
    cliRet += sysInfo
    if DeviceType.UNKNOWN == deviceType:
        if "zh" == lang:
            errMsg += u"\n未取到有效的设备型号。"
        else:
            errMsg += "\nFailed to get system device type."
        return (CheckedResult.NOTPASS, cliRet, errMsg)
    
    #步骤2：获取当前系统版本和升级目标版本
    currentVer = getCurSysVer(dataDict)
    destVer = getDestVer(dataDict)
    upgradeModel = getUpgradeModel(dataDict)
    
    cliRet += "\n" + getCliRet4UpgradePkgInfo(dataDict)
    logger.info("DoradoV1 VerLimitCheck currentVer: %s, destVer: %s." % (unicode(currentVer), unicode(destVer)))
    
    if DeviceType.Dorado2100G2 == deviceType:
        if currentVer <= "V100R001C00SPC700" and upgradeModel == "OFFLINE":
            flag = CheckedResult.NOTPASS
            if "zh" == lang:
                errMsg += u"\n当前版本不能进行离线升级，请选择在线升级方式进行评估。"
            else:
                errMsg += "\nThe current version cannot be upgraded in offline mode. Please select online upgrade for the evaluation."
        if currentVer <= "V100R001C00SPC200" and destVer >= "V100R001C00SPCb00":
            flag = CheckedResult.NOTPASS
            if "zh" == lang:
                errMsg += u"\n当前版本不能直接升级到V100R001C00SPCb00或之后版本，请先升级到V100R001C00SPCa00再升级到V100R001C00SPCb00或之后版本。"
            else:
                errMsg += "\nThe current version cannot be directly upgraded to V100R001C00SPCb00 or later. Please upgrade it to V100R001C00SPCa00 and then V100R001C00SPCb00 or later."
    
    if DeviceType.Dorado5100 == deviceType:
        if currentVer <= "V100R001C00SPC600" and upgradeModel == "OFFLINE":
            flag = CheckedResult.NOTPASS
            if "zh" == lang:
                errMsg += u"\n当前版本不能进行离线升级，请选择在线升级方式进行评估。"
            else:
                errMsg += "\nThe current version cannot be upgraded in offline mode. Please select online upgrade for the evaluation."
                
    return (flag, cliRet, errMsg)
